/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.config.Config;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathServiceConfig {
    private static final Logger logger = LoggerFactory.getLogger(PathServiceConfig.class);
    public static final String CONFIG_NAME = "pathService";
    private static final String ENABLED = "enabled";
    private static final String MAPPING = "mapping";
    private Map<String, Object> mappedConfig;
    private Map<String, String> mapping;
    private boolean enabled;
    private Config config = Config.getInstance();

    private PathServiceConfig() {
        this(CONFIG_NAME);
    }

    private PathServiceConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setMap();
        this.setConfigData();
    }

    public static PathServiceConfig load() {
        return new PathServiceConfig();
    }

    public static PathServiceConfig load(String configName) {
        return new PathServiceConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setMap();
        this.setConfigData();
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    private void setMap() {
        if (this.mappedConfig.get(MAPPING) != null) {
            if (this.mappedConfig.get(MAPPING) instanceof String) {
                String s = (String)this.mappedConfig.get(MAPPING);
                s = s.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s);
                }
                if (s.startsWith("{")) {
                    try {
                        this.mapping = (Map)Config.getInstance().getMapper().readValue(s, Map.class);
                    }
                    catch (IOException e) {
                        logger.error("IOException:", (Throwable)e);
                    }
                } else {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    for (String keyValue : s.split(" *& *")) {
                        String[] pairs = keyValue.split(" *= *", 2);
                        map.put(pairs[0], pairs.length == 1 ? "" : pairs[1]);
                    }
                    this.mapping = map;
                }
            } else if (this.mappedConfig.get(MAPPING) instanceof Map) {
                this.mapping = (Map)this.mappedConfig.get(MAPPING);
            } else {
                logger.error("mapping is the wrong type. Only JSON string and YAML map are supported.");
            }
        }
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(ENABLED);
        if (object != null && ((Boolean)object).booleanValue()) {
            this.enabled = true;
        }
    }
}

