/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.router.middleware.PathServiceConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathServiceHandler
implements MiddlewareHandler {
    static Logger logger = LoggerFactory.getLogger(PathServiceHandler.class);
    private volatile HttpHandler next;
    private static PathServiceConfig config;

    public PathServiceHandler() {
        logger.info("PathServiceHandler is constructed");
        config = PathServiceConfig.load();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderValues serviceIdHeader;
        String serviceId;
        if (logger.isDebugEnabled()) {
            logger.debug("PathServiceConfig.handleRequest starts.");
        }
        String string = serviceId = (serviceIdHeader = exchange.getRequestHeaders().get(HttpStringConstants.SERVICE_ID)) != null ? serviceIdHeader.peekFirst() : null;
        if (serviceId == null) {
            Map auditInfo = (Map)exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
            if (auditInfo != null) {
                String endpoint = (String)auditInfo.get("endpoint");
                if (logger.isDebugEnabled()) {
                    logger.debug("endpoint = " + endpoint);
                }
                if (endpoint != null) {
                    String string2 = serviceId = config.getMapping() == null ? null : config.getMapping().get(endpoint);
                    if (serviceId != null) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Put into the service_id header for serviceId = " + serviceId);
                        }
                        exchange.getRequestHeaders().put(HttpStringConstants.SERVICE_ID, serviceId);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("The endpoint is not in the mapping config");
                    }
                } else {
                    logger.error("could not get endpoint from the auditInfo.");
                }
            } else {
                logger.error("could not find auditInfo object in exchange attachment.");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("PathServiceConfig.handleRequest ends.");
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)PathServiceHandler.class.getName(), config.getMappedConfig(), null);
    }

    public void reload() {
        config.reload();
        ModuleRegistry.registerModule((String)PathServiceHandler.class.getName(), config.getMappedConfig(), null);
    }
}

