/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.SAMLBearerRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLTokenHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "token";
    public static final String CLIENT_CONFIG_NAME = "client";
    public static final String ENABLED = "enabled";
    public static final String CONFIG_SECURITY = "security";
    public static Map<String, Object> config = Config.getInstance().getJsonMapConfigNoCache("token");
    static Logger logger = LoggerFactory.getLogger(SAMLTokenHandler.class);
    protected volatile HttpHandler next;
    static final String OAUTH = "oauth";
    static final String TOKEN = "token";
    static final String OAUTH_HTTP2_SUPPORT = "oauthHttp2Support";
    static final String SAMLAssertionHeader = "assertion";
    static final String JWTAssertionHeader = "client_assertion";
    static final String STATUS_SAMLBEARER_CREDENTIALS_TOKEN_NOT_AVAILABLE = "ERR10009";
    static Map<String, Object> clientConfig;
    static Map<String, Object> tokenConfig;
    static boolean oauthHttp2Support;
    private final Object lock = new Object();

    public SAMLTokenHandler() {
        Map securityConfig;
        Map oauthConfig;
        clientConfig = Config.getInstance().getJsonMapConfig(CLIENT_CONFIG_NAME);
        if (clientConfig != null && (oauthConfig = (Map)clientConfig.get(OAUTH)) != null) {
            tokenConfig = (Map)oauthConfig.get("token");
        }
        if ((securityConfig = Config.getInstance().getJsonMapConfig(CONFIG_SECURITY)) != null) {
            Boolean b = (Boolean)securityConfig.get(OAUTH_HTTP2_SUPPORT);
            oauthHttp2Support = b == null ? false : b;
        }
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        logger.debug(exchange.toString());
        Result<String> result = this.getSAMLBearerToken(exchange.getRequestHeaders().getFirst(SAMLAssertionHeader), exchange.getRequestHeaders().getFirst(JWTAssertionHeader));
        if (result.isFailure()) {
            OauthHelper.sendStatusToResponse((HttpServerExchange)exchange, (Status)result.getError());
            return;
        }
        exchange.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + (String)result.getResult());
        exchange.getRequestHeaders().remove(SAMLAssertionHeader);
        exchange.getRequestHeaders().remove(JWTAssertionHeader);
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        Object object = config.get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    public void register() {
        ModuleRegistry.registerModule((String)SAMLTokenHandler.class.getName(), config, null);
    }

    public void reload() {
        config = Config.getInstance().getJsonMapConfigNoCache("token");
    }

    private Result<String> getSAMLBearerToken(String samlAssertion, String jwtAssertion) {
        SAMLBearerRequest tokenRequest = new SAMLBearerRequest(samlAssertion, jwtAssertion);
        Result tokenResponse = OauthHelper.getTokenFromSamlResult((SAMLBearerRequest)tokenRequest);
        if (tokenResponse.isSuccess()) {
            String jwt = ((TokenResponse)tokenResponse.getResult()).getAccessToken();
            logger.debug("SAMLBearer Grant Type jwt: ", (Object)jwt);
            return Success.of((Object)jwt);
        }
        return Failure.of((Status)tokenResponse.getError());
    }
}

