/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.config.Config;
import com.networknt.router.middleware.HandlerUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDictConfig {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDictConfig.class);
    public static final String CONFIG_NAME = "serviceDict";
    private static final String ENABLED = "enabled";
    private static final String MAPPING = "mapping";
    private Map<String, Object> mappedConfig;
    private Map<String, String> mapping;
    private boolean enabled;
    private Config config = Config.getInstance();

    private ServiceDictConfig() {
        this(CONFIG_NAME);
    }

    private ServiceDictConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setMap();
        this.setConfigData();
    }

    public static ServiceDictConfig load() {
        return new ServiceDictConfig();
    }

    public static ServiceDictConfig load(String configName) {
        return new ServiceDictConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setMap();
        this.setConfigData();
    }

    public Map<String, String> getMapping() {
        return this.mapping;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    Config getConfig() {
        return this.config;
    }

    private void setMap() {
        LinkedHashMap<String, String> rawMapping = null;
        if (this.mappedConfig.get(MAPPING) != null) {
            if (this.mappedConfig.get(MAPPING) instanceof String) {
                String s = (String)this.mappedConfig.get(MAPPING);
                s = s.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s);
                }
                if (s.startsWith("{")) {
                    try {
                        this.mapping = (Map)Config.getInstance().getMapper().readValue(s, Map.class);
                    }
                    catch (IOException e) {
                        logger.error("IOException:", (Throwable)e);
                    }
                } else {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    for (String keyValue : s.split(" *& *")) {
                        String[] pairs = keyValue.split(" *= *", 2);
                        map.put(pairs[0], pairs.length == 1 ? "" : pairs[1]);
                    }
                    rawMapping = map;
                }
            } else if (this.mappedConfig.get(MAPPING) instanceof Map) {
                rawMapping = (LinkedHashMap<String, String>)this.mappedConfig.get(MAPPING);
            } else {
                logger.error("mapping is the wrong type. Only JSON string and YAML map are supported.");
            }
            this.mapping = new HashMap<String, String>();
            for (Map.Entry entry : rawMapping.entrySet()) {
                this.mapping.put(HandlerUtils.toInternalKey((String)entry.getKey()), (String)entry.getValue());
            }
            this.mapping = Collections.unmodifiableMap(this.mapping);
        }
    }

    private void setConfigData() {
        Object object = this.getMappedConfig().get(ENABLED);
        if (object != null && ((Boolean)object).booleanValue()) {
            this.enabled = true;
        }
    }
}

