/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.router.middleware.HandlerUtils;
import com.networknt.router.middleware.ServiceDictConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDictHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDictHandler.class);
    protected volatile HttpHandler next;
    protected static ServiceDictConfig config;

    public ServiceDictHandler() {
        logger.info("ServiceDictHandler is constructed");
        config = ServiceDictConfig.load();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("ServiceDictHandler.handleRequest starts.");
        }
        this.serviceDict(exchange);
        if (logger.isDebugEnabled()) {
            logger.debug("ServiceDictHandler.handleRequest ends.");
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    protected void serviceDict(HttpServerExchange exchange) throws Exception {
        HashMap<String, Object> auditInfo;
        String serviceId;
        String requestPath = exchange.getRequestURI();
        String httpMethod = exchange.getRequestMethod().toString().toLowerCase();
        String[] serviceEntry = HandlerUtils.findServiceEntry(HandlerUtils.toInternalKey(httpMethod, requestPath), config.getMapping());
        HeaderValues serviceIdHeader = exchange.getRequestHeaders().get(HttpStringConstants.SERVICE_ID);
        String string = serviceId = serviceIdHeader != null ? serviceIdHeader.peekFirst() : null;
        if (serviceId == null && serviceEntry != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("serviceEntry found and header is set for service_id = " + serviceEntry[1]);
            }
            exchange.getRequestHeaders().put(HttpStringConstants.SERVICE_ID, serviceEntry[1]);
        }
        if ((auditInfo = (HashMap<String, Object>)exchange.getAttachment(AttachmentConstants.AUDIT_INFO)) == null) {
            auditInfo = new HashMap<String, Object>();
            if (serviceEntry != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("auditInfo is null and serviceEntry found and endpoint is set for = " + serviceEntry[0]);
                }
                auditInfo.put("endpoint", serviceEntry[0]);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("auditInfo is null and serviceEntry not found and endpoint is set for = unknown@" + exchange.getRequestMethod().toString().toLowerCase());
                }
                auditInfo.put("endpoint", "unknown@" + exchange.getRequestMethod().toString().toLowerCase());
            }
            exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
        } else {
            if (!auditInfo.containsKey("endpoint")) {
                if (serviceEntry != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("auditInfo is not null and serviceEntry found and endpoint is set for = " + serviceEntry[0]);
                    }
                    auditInfo.put("endpoint", serviceEntry[0]);
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.trace("auditInfo is not null and serviceEntry not found and endpoint is set for = unknown@" + exchange.getRequestMethod().toString().toLowerCase());
                    }
                    auditInfo.put("endpoint", "unknown@" + exchange.getRequestMethod().toString().toLowerCase());
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("auditInfo is not null and endpoint value is  = " + auditInfo.get("endpoint"));
            }
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)ServiceDictHandler.class.getName(), config.getMappedConfig(), null);
    }

    public void reload() {
        config.reload();
        ModuleRegistry.registerModule((String)ServiceDictHandler.class.getName(), config.getMappedConfig(), null);
    }
}

