/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenConfig {
    private static final Logger logger = LoggerFactory.getLogger(TokenConfig.class);
    static final String CONFIG_NAME = "token";
    private static final String ENABLED = "enabled";
    private static final String APPLIED_PATH_PREFIXES = "appliedPathPrefixes";
    boolean enabled;
    List<String> appliedPathPrefixes;
    private Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private TokenConfig() {
        this(CONFIG_NAME);
    }

    private TokenConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigList();
        this.setConfigData();
    }

    public static TokenConfig load() {
        return new TokenConfig();
    }

    public static TokenConfig load(String configName) {
        return new TokenConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigList();
        this.setConfigData();
    }

    public void setConfigData() {
        Object object = this.getMappedConfig().get(ENABLED);
        if (object != null && ((Boolean)object).booleanValue()) {
            this.enabled = true;
        }
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getAppliedPathPrefixes() {
        return this.appliedPathPrefixes;
    }

    public void setAppliedPathPrefixes(List<String> appliedPathPrefixes) {
        this.appliedPathPrefixes = appliedPathPrefixes;
    }

    private void setConfigList() {
        if (this.mappedConfig.get(APPLIED_PATH_PREFIXES) != null) {
            Object object = this.mappedConfig.get(APPLIED_PATH_PREFIXES);
            this.appliedPathPrefixes = new ArrayList<String>();
            if (object instanceof String) {
                String s = (String)object;
                s = s.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s);
                }
                if (s.startsWith("[")) {
                    try {
                        this.appliedPathPrefixes = (List)Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the appliedPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.appliedPathPrefixes = Arrays.asList(s.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                List prefixes = (List)object;
                prefixes.forEach(item -> this.appliedPathPrefixes.add((String)item));
            } else {
                throw new ConfigException("appliedPathPrefixes must be a string or a list of strings.");
            }
        }
    }
}

