/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.router.middleware;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.router.middleware.TokenConfig;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenHandler
implements MiddlewareHandler {
    private static final String HANDLER_DEPENDENCY_ERROR = "ERR10074";
    private static TokenConfig config;
    static Logger logger;
    protected volatile HttpHandler next;
    public static final Map<String, Jwt> cache;

    public TokenHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("TokenHandler is loaded.");
        }
        config = TokenConfig.load();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("TokenHandler.handleRequest starts.");
        }
        String requestPath = exchange.getRequestPath();
        if (config.getAppliedPathPrefixes() != null && config.getAppliedPathPrefixes().stream().anyMatch(s -> requestPath.startsWith((String)s))) {
            HeaderValues headerValues = exchange.getRequestHeaders().get(HttpStringConstants.SERVICE_ID);
            String serviceId = null;
            if (headerValues != null) {
                serviceId = headerValues.getFirst();
            }
            if (serviceId == null) {
                logger.error("The serviceId cannot be resolved. Do you have PathPrefixServiceHandler or ServiceDictHandler before this handler?");
                this.setExchangeStatus(exchange, HANDLER_DEPENDENCY_ERROR, new Object[]{"TokenHandler", "PathPrefixServiceHandler"});
                if (logger.isDebugEnabled()) {
                    logger.debug("TokenHandler.handleRequest ends with an error.");
                }
                return;
            }
            Result<Jwt> result = TokenHandler.getJwtToken(serviceId);
            if (result.isFailure()) {
                logger.error("Cannot populate or renew jwt for client credential grant type: " + result.getError().toString());
                this.setExchangeStatus(exchange, result.getError());
                if (logger.isDebugEnabled()) {
                    logger.debug("TokenHandler.handleRequest ends with an error.");
                }
                return;
            }
            Jwt cachedJwt = (Jwt)result.getResult();
            String token = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
            if (token == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Adding jwt token to Authorization header with Bearer " + cachedJwt.getJwt().substring(0, 20));
                }
                exchange.getRequestHeaders().put(Headers.AUTHORIZATION, "Bearer " + cachedJwt.getJwt());
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Authorization header is used with " + (token.length() > 10 ? token.substring(0, 10) : token));
                    logger.trace("Adding jwt token to X-Scope-Token header with Bearer " + cachedJwt.getJwt().substring(0, 20));
                }
                exchange.getRequestHeaders().put(HttpStringConstants.SCOPE_TOKEN, "Bearer " + cachedJwt.getJwt());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("TokenHandler.handleRequest ends.");
        }
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public static Result<Jwt> getJwtToken(String serviceId) {
        Result result;
        ClientConfig clientConfig = ClientConfig.get();
        Map tokenConfig = clientConfig.getTokenConfig();
        Map ccConfig = (Map)tokenConfig.get("client_credentials");
        Jwt cachedJwt = cache.get(serviceId);
        if (cachedJwt == null || cachedJwt.getExpire() - Long.valueOf(((Integer)tokenConfig.get("tokenRenewBeforeExpired")).intValue()) < System.currentTimeMillis()) {
            Jwt.Key key = new Jwt.Key(serviceId);
            cachedJwt = new Jwt(key);
            if (clientConfig.isMultipleAuthServers()) {
                Map serviceIdAuthServers = (Map)ccConfig.get("serviceIdAuthServers");
                if (serviceIdAuthServers == null) {
                    throw new RuntimeException("serviceIdAuthServers property is missing in the token client credentials configuration");
                }
                Map authServerConfig = (Map)serviceIdAuthServers.get(serviceId);
                if (authServerConfig.get("proxyHost") == null) {
                    authServerConfig.put("proxyHost", tokenConfig.get("proxyHost"));
                }
                if (authServerConfig.get("proxyPort") == null) {
                    authServerConfig.put("proxyPort", tokenConfig.get("proxyPort"));
                }
                if (authServerConfig.get("tokenRenewBeforeExpired") == null) {
                    authServerConfig.put("tokenRenewBeforeExpired", tokenConfig.get("tokenRenewBeforeExpired"));
                }
                if (authServerConfig.get("expiredRefreshRetryDelay") == null) {
                    authServerConfig.put("expiredRefreshRetryDelay", tokenConfig.get("expiredRefreshRetryDelay"));
                }
                if (authServerConfig.get("earlyRefreshRetryDelay") == null) {
                    authServerConfig.put("earlyRefreshRetryDelay", tokenConfig.get("earlyRefreshRetryDelay"));
                }
                cachedJwt.setCcConfig(authServerConfig);
            } else {
                ccConfig.put("proxyHost", tokenConfig.get("proxyHost"));
                ccConfig.put("proxyPort", tokenConfig.get("proxyPort"));
                ccConfig.put("tokenRenewBeforeExpired", tokenConfig.get("tokenRenewBeforeExpired"));
                ccConfig.put("expiredRefreshRetryDelay", tokenConfig.get("expiredRefreshRetryDelay"));
                ccConfig.put("earlyRefreshRetryDelay", tokenConfig.get("earlyRefreshRetryDelay"));
                cachedJwt.setCcConfig(ccConfig);
            }
            result = OauthHelper.populateCCToken((Jwt)cachedJwt);
            if (result.isSuccess()) {
                cache.put(serviceId, cachedJwt);
            }
        } else {
            result = Success.of((Object)cachedJwt);
        }
        return result;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)TokenHandler.class.getName(), config.getMappedConfig(), null);
    }

    public void reload() {
        config.reload();
        ModuleRegistry.registerModule((String)TokenHandler.class.getName(), config.getMappedConfig(), null);
    }

    static {
        logger = LoggerFactory.getLogger(TokenHandler.class);
        cache = new ConcurrentHashMap<String, Jwt>();
    }
}

