/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.email;

import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import com.networknt.email.EmailConfig;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSender {
    private static final Logger logger = LoggerFactory.getLogger(EmailSender.class);
    public static final String CONFIG_EMAIL = "email";
    public static final String CONFIG_SECRET = "secret";
    static final EmailConfig emailConfg = (EmailConfig)Config.getInstance().getJsonObjectConfig("email", EmailConfig.class);
    static final Map<String, Object> secret = DecryptUtil.decryptMap((Map)Config.getInstance().getJsonMapConfig("secret"));

    public void sendMail(String to, String subject, String content) throws MessagingException {
        Properties props = new Properties();
        props.put("mail.smtp.user", emailConfg.getUser());
        props.put("mail.smtp.host", emailConfg.getHost());
        props.put("mail.smtp.port", emailConfg.getPort());
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.debug", emailConfg.getDebug());
        props.put("mail.smtp.auth", emailConfg.getAuth());
        props.put("mail.smtp.ssl.trust", EmailSender.emailConfg.host);
        SMTPAuthenticator auth = new SMTPAuthenticator(emailConfg.getUser(), (String)secret.get("emailPassword"));
        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(emailConfg.getUser()));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        message.setSubject(subject);
        message.setContent((Object)content, "text/html");
        Transport.send((Message)message);
        if (logger.isInfoEnabled()) {
            logger.info("An email has been sent to " + to + " with subject " + subject);
        }
    }

    public void sendMailWithAttachment(String to, String subject, String content, String filename) throws MessagingException {
        Properties props = new Properties();
        props.put("mail.smtp.user", emailConfg.getUser());
        props.put("mail.smtp.host", emailConfg.getHost());
        props.put("mail.smtp.port", emailConfg.getPort());
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.debug", emailConfg.getDebug());
        props.put("mail.smtp.auth", emailConfg.getAuth());
        props.put("mail.smtp.ssl.trust", EmailSender.emailConfg.host);
        SMTPAuthenticator auth = new SMTPAuthenticator(emailConfg.getUser(), (String)secret.get("emailPassword"));
        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(emailConfg.getUser()));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        message.setSubject(subject);
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(content);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        messageBodyPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(filename);
        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
        messageBodyPart.setFileName(filename);
        multipart.addBodyPart((BodyPart)messageBodyPart);
        message.setContent((Multipart)multipart);
        Transport.send((Message)message);
        if (logger.isInfoEnabled()) {
            logger.info("An email has been sent to " + to + " with subject " + subject);
        }
    }

    private static class SMTPAuthenticator
    extends Authenticator {
        public String user;
        public String password;

        public SMTPAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
}

