/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.cdc.polling;

import com.networknt.eventuate.server.common.CdcKafkaPublisher;
import com.networknt.eventuate.server.common.PublishingStrategy;
import com.networknt.eventuate.server.common.exception.EventuateLocalPublishingException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingCdcKafkaPublisher<EVENT>
extends CdcKafkaPublisher<EVENT> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public PollingCdcKafkaPublisher(String kafkaBootstrapServers, PublishingStrategy<EVENT> publishingStrategy) {
        super(publishingStrategy);
    }

    public void handleEvent(EVENT event) throws EventuateLocalPublishingException {
        this.logger.trace("Got record " + event.toString());
        String aggregateTopic = this.publishingStrategy.topicFor(event);
        String json = this.publishingStrategy.toJson(event);
        Exception lastException = null;
        for (int i = 0; i < 5; ++i) {
            try {
                this.producer.send(aggregateTopic, this.publishingStrategy.partitionKeyFor(event), json).get(10L, TimeUnit.SECONDS);
                return;
            }
            catch (Exception e) {
                this.logger.warn("error publishing to " + aggregateTopic, (Throwable)e);
                lastException = e;
                try {
                    Thread.sleep((int)Math.pow(2.0, i) * 1000);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
        }
        throw new EventuateLocalPublishingException("error publishing to " + aggregateTopic, lastException);
    }
}

