/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;
import java.io.IOException;
import java.util.OptionalLong;

public class OptionalLongDeserializer
extends BaseScalarOptionalDeserializer<OptionalLong> {
    private static final long serialVersionUID = 1L;
    static final OptionalLongDeserializer INSTANCE = new OptionalLongDeserializer();

    public OptionalLongDeserializer() {
        super(OptionalLong.class, OptionalLong.empty());
    }

    @Override
    public OptionalLong deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return OptionalLong.of(p2.getLongValue());
        }
        switch (p2.getCurrentTokenId()) {
            case 6: {
                String text = p2.getText().trim();
                if (text.length() == 0) {
                    this._coerceEmptyString(ctxt, false);
                    return (OptionalLong)this._empty;
                }
                if (this._hasTextualNull(text)) {
                    this._coerceTextualNull(ctxt, false);
                    return (OptionalLong)this._empty;
                }
                return OptionalLong.of(this._parseLongPrimitive(ctxt, text));
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p2, ctxt, "long");
                }
                return OptionalLong.of(p2.getValueAsLong());
            }
            case 11: {
                return (OptionalLong)this._empty;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p2.nextToken();
                OptionalLong parsed = this.deserialize(p2, ctxt);
                this._verifyEndArrayForSingle(p2, ctxt);
                return parsed;
            }
        }
        return (OptionalLong)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }
}

