/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BBHeader;
import com.github.benmanes.caffeine.cache.Buffer;
import com.github.benmanes.caffeine.cache.StripedBuffer;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;

final class BoundedBuffer<E>
extends StripedBuffer<E> {
    static final int BUFFER_SIZE = 16;
    static final int SPACED_SIZE = 256;
    static final int SPACED_MASK = 255;
    static final int OFFSET = 16;

    BoundedBuffer() {
    }

    @Override
    protected Buffer<E> create(E e2) {
        return new RingBuffer<E>(e2);
    }

    static final class RingBuffer<E>
    extends BBHeader.ReadAndWriteCounterRef
    implements Buffer<E> {
        final AtomicReferenceArray<E> buffer = new AtomicReferenceArray(256);

        public RingBuffer(E e2) {
            this.buffer.lazySet(0, e2);
        }

        @Override
        public int offer(E e2) {
            long head = this.readCounter;
            long tail = this.relaxedWriteCounter();
            long size = tail - head;
            if (size >= 256L) {
                return 1;
            }
            if (this.casWriteCounter(tail, tail + 16L)) {
                int index = (int)(tail & 0xFFL);
                this.buffer.lazySet(index, e2);
                return 0;
            }
            return -1;
        }

        @Override
        public void drainTo(Consumer<E> consumer) {
            int index;
            E e2;
            long head = this.readCounter;
            long tail = this.relaxedWriteCounter();
            long size = tail - head;
            if (size == 0L) {
                return;
            }
            while ((e2 = this.buffer.get(index = (int)(head & 0xFFL))) != null) {
                this.buffer.lazySet(index, null);
                consumer.accept(e2);
                if ((head += 16L) != tail) continue;
            }
            this.lazySetReadCounter(head);
        }

        @Override
        public int reads() {
            return (int)this.readCounter / 16;
        }

        @Override
        public int writes() {
            return (int)this.writeCounter / 16;
        }
    }
}

