/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.base.UnsafeAccess;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.NodeFactory;
import com.github.benmanes.caffeine.cache.References;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;

class FS<K, V>
extends Node<K, V>
implements NodeFactory<K, V> {
    protected static final long KEY_OFFSET = UnsafeAccess.objectFieldOffset(FS.class, "key");
    protected static final long VALUE_OFFSET = UnsafeAccess.objectFieldOffset(FS.class, "value");
    volatile References.WeakKeyReference<K> key;
    volatile V value;

    FS() {
    }

    FS(K k2, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n2, long l2) {
        this(new References.WeakKeyReference<K>(k2, referenceQueue), v, referenceQueue2, n2, l2);
    }

    FS(Object object, V v, ReferenceQueue<V> referenceQueue, int n2, long l2) {
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, object);
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, v);
    }

    @Override
    public final K getKey() {
        return (K)((Reference)UnsafeAccess.UNSAFE.getObject(this, KEY_OFFSET)).get();
    }

    @Override
    public final Object getKeyReference() {
        return UnsafeAccess.UNSAFE.getObject(this, KEY_OFFSET);
    }

    @Override
    public final V getValue() {
        return (V)UnsafeAccess.UNSAFE.getObject(this, VALUE_OFFSET);
    }

    @Override
    public final Object getValueReference() {
        return UnsafeAccess.UNSAFE.getObject(this, VALUE_OFFSET);
    }

    @Override
    public final void setValue(V v, ReferenceQueue<V> referenceQueue) {
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, v);
    }

    @Override
    public final boolean containsValue(Object object) {
        return Objects.equals(object, this.getValue());
    }

    @Override
    public Node<K, V> newNode(K k2, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n2, long l2) {
        return new FS<K, V>(k2, referenceQueue, v, referenceQueue2, n2, l2);
    }

    @Override
    public Node<K, V> newNode(Object object, V v, ReferenceQueue<V> referenceQueue, int n2, long l2) {
        return new FS<K, V>(object, v, referenceQueue, n2, l2);
    }

    @Override
    public Object newLookupKey(Object object) {
        return new References.LookupKeyReference<Object>(object);
    }

    @Override
    public Object newReferenceKey(K k2, ReferenceQueue<K> referenceQueue) {
        return new References.WeakKeyReference<K>(k2, referenceQueue);
    }

    @Override
    public final boolean isAlive() {
        Object object = this.getKeyReference();
        return object != RETIRED_WEAK_KEY && object != DEAD_WEAK_KEY;
    }

    @Override
    public final boolean isRetired() {
        return this.getKeyReference() == RETIRED_WEAK_KEY;
    }

    @Override
    public final void retire() {
        ((Reference)this.getKeyReference()).clear();
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, RETIRED_WEAK_KEY);
    }

    @Override
    public final boolean isDead() {
        return this.getKeyReference() == DEAD_WEAK_KEY;
    }

    @Override
    public final void die() {
        ((Reference)this.getKeyReference()).clear();
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, null);
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, DEAD_WEAK_KEY);
    }
}

