/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.base.UnsafeAccess;
import com.github.benmanes.caffeine.cache.AccessOrderDeque;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.FrequencySketch;
import com.github.benmanes.caffeine.cache.MpscGrowableArrayQueue;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.SIS;

class SISMS<K, V>
extends SIS<K, V> {
    protected static final long MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "maximum");
    protected static final long EDEN_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "edenMaximum");
    protected static final long MAIN_PROTECTED_MAXIMUM_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "mainProtectedMaximum");
    protected static final long WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "weightedSize");
    protected static final long EDEN_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "edenWeightedSize");
    protected static final long MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET = UnsafeAccess.objectFieldOffset(SISMS.class, "mainProtectedWeightedSize");
    volatile long maximum;
    volatile long edenMaximum;
    volatile long mainProtectedMaximum;
    volatile long weightedSize;
    volatile long edenWeightedSize;
    volatile long mainProtectedWeightedSize;
    final FrequencySketch<K> sketch = new FrequencySketch();
    final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque;
    final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque;
    final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque;
    final MpscGrowableArrayQueue<Runnable> writeBuffer;

    SISMS(Caffeine<K, V> caffeine, CacheLoader<? super K, V> cacheLoader, boolean bl) {
        super(caffeine, cacheLoader, bl);
        if (caffeine.hasInitialCapacity()) {
            long l2 = Math.min(caffeine.getMaximum(), (long)caffeine.getInitialCapacity());
            this.sketch.ensureCapacity(l2);
        }
        this.accessOrderEdenDeque = caffeine.evicts() || caffeine.expiresAfterAccess() ? new AccessOrderDeque() : null;
        this.accessOrderProbationDeque = new AccessOrderDeque();
        this.accessOrderProtectedDeque = new AccessOrderDeque();
        this.writeBuffer = new MpscGrowableArrayQueue(4, WRITE_BUFFER_MAX);
    }

    @Override
    protected final boolean evicts() {
        return true;
    }

    @Override
    protected final long maximum() {
        return UnsafeAccess.UNSAFE.getLong(this, MAXIMUM_OFFSET);
    }

    @Override
    protected final void lazySetMaximum(long l2) {
        UnsafeAccess.UNSAFE.putLong(this, MAXIMUM_OFFSET, l2);
    }

    @Override
    protected final long edenMaximum() {
        return UnsafeAccess.UNSAFE.getLong(this, EDEN_MAXIMUM_OFFSET);
    }

    @Override
    protected final void lazySetEdenMaximum(long l2) {
        UnsafeAccess.UNSAFE.putLong(this, EDEN_MAXIMUM_OFFSET, l2);
    }

    @Override
    protected final long mainProtectedMaximum() {
        return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET);
    }

    @Override
    protected final void lazySetMainProtectedMaximum(long l2) {
        UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_MAXIMUM_OFFSET, l2);
    }

    @Override
    protected final long weightedSize() {
        return UnsafeAccess.UNSAFE.getLong(this, WEIGHTED_SIZE_OFFSET);
    }

    @Override
    protected final void lazySetWeightedSize(long l2) {
        UnsafeAccess.UNSAFE.putLong(this, WEIGHTED_SIZE_OFFSET, l2);
    }

    @Override
    protected final long edenWeightedSize() {
        return UnsafeAccess.UNSAFE.getLong(this, EDEN_WEIGHTED_SIZE_OFFSET);
    }

    @Override
    protected final void lazySetEdenWeightedSize(long l2) {
        UnsafeAccess.UNSAFE.putLong(this, EDEN_WEIGHTED_SIZE_OFFSET, l2);
    }

    @Override
    protected final long mainProtectedWeightedSize() {
        return UnsafeAccess.UNSAFE.getLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET);
    }

    @Override
    protected final void lazySetMainProtectedWeightedSize(long l2) {
        UnsafeAccess.UNSAFE.putLong(this, MAIN_PROTECTED_WEIGHTED_SIZE_OFFSET, l2);
    }

    @Override
    protected final FrequencySketch<K> frequencySketch() {
        return this.sketch;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
        return this.accessOrderEdenDeque;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
        return this.accessOrderProbationDeque;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
        return this.accessOrderProtectedDeque;
    }

    @Override
    protected final MpscGrowableArrayQueue<Runnable> writeBuffer() {
        return this.writeBuffer;
    }

    @Override
    protected final boolean buffersWrites() {
        return true;
    }
}

