/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BoundedLocalCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class TimerWheel<K, V> {
    static final int[] BUCKETS = new int[]{64, 64, 32, 4, 1};
    static final long[] SPANS = new long[]{TimerWheel.ceilingPowerOfTwo(TimeUnit.SECONDS.toNanos(1L)), TimerWheel.ceilingPowerOfTwo(TimeUnit.MINUTES.toNanos(1L)), TimerWheel.ceilingPowerOfTwo(TimeUnit.HOURS.toNanos(1L)), TimerWheel.ceilingPowerOfTwo(TimeUnit.DAYS.toNanos(1L)), (long)BUCKETS[3] * TimerWheel.ceilingPowerOfTwo(TimeUnit.DAYS.toNanos(1L)), (long)BUCKETS[3] * TimerWheel.ceilingPowerOfTwo(TimeUnit.DAYS.toNanos(1L))};
    static final long[] SHIFT = new long[]{64 - Long.numberOfLeadingZeros(SPANS[0] - 1L), 64 - Long.numberOfLeadingZeros(SPANS[1] - 1L), 64 - Long.numberOfLeadingZeros(SPANS[2] - 1L), 64 - Long.numberOfLeadingZeros(SPANS[3] - 1L), 64 - Long.numberOfLeadingZeros(SPANS[4] - 1L)};
    final BoundedLocalCache<K, V> cache;
    final Node<K, V>[][] wheel;
    long nanos;

    TimerWheel(BoundedLocalCache<K, V> cache) {
        this.cache = Objects.requireNonNull(cache);
        this.wheel = new Node[BUCKETS.length][1];
        for (int i2 = 0; i2 < this.wheel.length; ++i2) {
            this.wheel[i2] = new Node[BUCKETS[i2]];
            for (int j2 = 0; j2 < this.wheel[i2].length; ++j2) {
                this.wheel[i2][j2] = new Sentinel();
            }
        }
    }

    public void advance(long currentTimeNanos) {
        long previousTimeNanos = this.nanos;
        try {
            long previousTicks;
            long currentTicks;
            this.nanos = currentTimeNanos;
            for (int i2 = 0; i2 < SHIFT.length && (currentTicks = currentTimeNanos >> (int)SHIFT[i2]) - (previousTicks = previousTimeNanos >> (int)SHIFT[i2]) > 0L; ++i2) {
                this.expire(i2, previousTicks, currentTicks);
            }
        }
        catch (Throwable t) {
            this.nanos = previousTimeNanos;
            throw t;
        }
    }

    void expire(int index, long previousTicks, long currentTicks) {
        int start;
        int end;
        Node<K, V>[] timerWheel = this.wheel[index];
        if (currentTicks - previousTicks >= (long)timerWheel.length) {
            end = timerWheel.length;
            start = 0;
        } else {
            long mask = SPANS[index] - 1L;
            start = (int)(previousTicks & mask);
            end = 1 + (int)(currentTicks & mask);
        }
        int mask = timerWheel.length - 1;
        for (int i2 = start; i2 < end; ++i2) {
            Node<K, V> sentinel = timerWheel[i2 & mask];
            Node<K, V> prev = sentinel.getPreviousInVariableOrder();
            Node<K, V> node = sentinel.getNextInVariableOrder();
            sentinel.setPreviousInVariableOrder(sentinel);
            sentinel.setNextInVariableOrder(sentinel);
            while (node != sentinel) {
                Node<K, V> next = node.getNextInVariableOrder();
                node.setPreviousInVariableOrder(null);
                node.setNextInVariableOrder(null);
                try {
                    if (node.getVariableTime() - this.nanos > 0L || !this.cache.evictEntry(node, RemovalCause.EXPIRED, this.nanos)) {
                        Node<K, V> newSentinel = this.findBucket(node.getVariableTime());
                        this.link(newSentinel, node);
                    }
                    node = next;
                }
                catch (Throwable t) {
                    node.setPreviousInVariableOrder(sentinel.getPreviousInVariableOrder());
                    node.setNextInVariableOrder(next);
                    sentinel.getPreviousInVariableOrder().setNextInVariableOrder(node);
                    sentinel.setPreviousInVariableOrder(prev);
                    throw t;
                }
            }
        }
    }

    public void schedule(Node<K, V> node) {
        Node<K, V> sentinel = this.findBucket(node.getVariableTime());
        this.link(sentinel, node);
    }

    public void reschedule(Node<K, V> node) {
        if (node.getNextInVariableOrder() != null) {
            this.unlink(node);
            this.schedule(node);
        }
    }

    public void deschedule(Node<K, V> node) {
        this.unlink(node);
        node.setNextInVariableOrder(null);
        node.setPreviousInVariableOrder(null);
    }

    Node<K, V> findBucket(long time) {
        long duration = time - this.nanos;
        int length = this.wheel.length - 1;
        for (int i2 = 0; i2 < length; ++i2) {
            if (duration >= SPANS[i2 + 1]) continue;
            int ticks = (int)(time >> (int)SHIFT[i2]);
            int index = ticks & this.wheel[i2].length - 1;
            return this.wheel[i2][index];
        }
        return this.wheel[length][0];
    }

    void link(Node<K, V> sentinel, Node<K, V> node) {
        node.setPreviousInVariableOrder(sentinel.getPreviousInVariableOrder());
        node.setNextInVariableOrder(sentinel);
        sentinel.getPreviousInVariableOrder().setNextInVariableOrder(node);
        sentinel.setPreviousInVariableOrder(node);
    }

    void unlink(Node<K, V> node) {
        Node<K, V> next = node.getNextInVariableOrder();
        if (next != null) {
            Node<K, V> prev = node.getPreviousInVariableOrder();
            next.setPreviousInVariableOrder(prev);
            prev.setNextInVariableOrder(next);
        }
    }

    public Map<K, V> snapshot(boolean ascending, int limit, Function<V, V> transformer) {
        Caffeine.requireArgument(limit >= 0);
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(Math.min(limit, this.cache.size()));
        int startLevel = ascending ? 0 : this.wheel.length - 1;
        for (int i2 = 0; i2 < this.wheel.length; ++i2) {
            int indexOffset = ascending ? i2 : -i2;
            int index = startLevel + indexOffset;
            int ticks = (int)(this.nanos >> (int)SHIFT[index]);
            int bucketMask = this.wheel[index].length - 1;
            int startBucket = (ticks & bucketMask) + (ascending ? 1 : 0);
            for (int j2 = 0; j2 < this.wheel[index].length; ++j2) {
                int bucketOffset = ascending ? j2 : -j2;
                Node<K, V> sentinel = this.wheel[index][startBucket + bucketOffset & bucketMask];
                Node<K, V> node = TimerWheel.traverse(ascending, sentinel);
                while (node != sentinel && map.size() < limit) {
                    K key = node.getKey();
                    V value = transformer.apply(node.getValue());
                    if (key != null && value != null && node.isAlive()) {
                        map.put(key, value);
                    }
                    node = TimerWheel.traverse(ascending, node);
                }
            }
        }
        return Collections.unmodifiableMap(map);
    }

    static <K, V> Node<K, V> traverse(boolean ascending, Node<K, V> node) {
        return ascending ? node.getNextInVariableOrder() : node.getPreviousInVariableOrder();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < this.wheel.length; ++i2) {
            TreeMap buckets = new TreeMap();
            for (int j2 = 0; j2 < this.wheel[i2].length; ++j2) {
                ArrayList<K> events = new ArrayList<K>();
                for (Node<K, V> node = this.wheel[i2][j2].getNextInVariableOrder(); node != this.wheel[i2][j2]; node = node.getNextInVariableOrder()) {
                    events.add(node.getKey());
                }
                if (events.isEmpty()) continue;
                buckets.put(j2, events);
            }
            builder.append("Wheel #").append(i2 + 1).append(": ").append(buckets).append('\n');
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    static long ceilingPowerOfTwo(long x) {
        return 1L << -Long.numberOfLeadingZeros(x - 1L);
    }

    static final class Sentinel<K, V>
    extends Node<K, V> {
        Node<K, V> prev;
        Node<K, V> next;

        Sentinel() {
            this.prev = this.next = this;
        }

        @Override
        public Node<K, V> getPreviousInVariableOrder() {
            return this.prev;
        }

        @Override
        public void setPreviousInVariableOrder(@Nullable Node<K, V> prev) {
            this.prev = prev;
        }

        @Override
        public Node<K, V> getNextInVariableOrder() {
            return this.next;
        }

        @Override
        public void setNextInVariableOrder(@Nullable Node<K, V> next) {
            this.next = next;
        }

        @Override
        @Nullable
        public K getKey() {
            return null;
        }

        @Override
        public Object getKeyReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public V getValue() {
            return null;
        }

        @Override
        public Object getValueReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(V value, @Nullable ReferenceQueue<V> referenceQueue) {
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public boolean isAlive() {
            return false;
        }

        @Override
        public boolean isRetired() {
            return false;
        }

        @Override
        public boolean isDead() {
            return false;
        }

        @Override
        public void retire() {
        }

        @Override
        public void die() {
        }
    }
}

