/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.ColumnType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;

public class TableMapEventDataDeserializer
implements EventDataDeserializer<TableMapEventData> {
    @Override
    public TableMapEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        TableMapEventData eventData = new TableMapEventData();
        eventData.setTableId(inputStream.readLong(6));
        inputStream.skip(3L);
        eventData.setDatabase(inputStream.readZeroTerminatedString());
        inputStream.skip(1L);
        eventData.setTable(inputStream.readZeroTerminatedString());
        int numberOfColumns = inputStream.readPackedInteger();
        eventData.setColumnTypes(inputStream.read(numberOfColumns));
        inputStream.readPackedInteger();
        eventData.setColumnMetadata(this.readMetadata(inputStream, eventData.getColumnTypes()));
        eventData.setColumnNullability(inputStream.readBitSet(numberOfColumns, true));
        return eventData;
    }

    private int[] readMetadata(ByteArrayInputStream inputStream, byte[] columnTypes) throws IOException {
        int[] metadata = new int[columnTypes.length];
        block6: for (int i2 = 0; i2 < columnTypes.length; ++i2) {
            switch (ColumnType.byCode(columnTypes[i2] & 0xFF)) {
                case FLOAT: 
                case DOUBLE: 
                case BLOB: 
                case JSON: 
                case GEOMETRY: {
                    metadata[i2] = inputStream.readInteger(1);
                    continue block6;
                }
                case BIT: 
                case VARCHAR: 
                case NEWDECIMAL: {
                    metadata[i2] = inputStream.readInteger(2);
                    continue block6;
                }
                case SET: 
                case ENUM: 
                case STRING: {
                    metadata[i2] = TableMapEventDataDeserializer.bigEndianInteger(inputStream.read(2), 0, 2);
                    continue block6;
                }
                case TIME_V2: 
                case DATETIME_V2: 
                case TIMESTAMP_V2: {
                    metadata[i2] = inputStream.readInteger(1);
                    continue block6;
                }
                default: {
                    metadata[i2] = 0;
                }
            }
        }
        return metadata;
    }

    private static int bigEndianInteger(byte[] bytes, int offset, int length) {
        int result = 0;
        for (int i2 = offset; i2 < offset + length; ++i2) {
            int b2 = bytes[i2];
            result = result << 8 | (b2 >= 0 ? b2 : b2 + 256);
        }
        return result;
    }
}

