/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.io;

import com.github.shyiko.mysql.binlog.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;

public class ByteArrayInputStream
extends InputStream {
    private InputStream inputStream;
    private Integer peek;
    private int blockLength = -1;

    public ByteArrayInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public ByteArrayInputStream(byte[] bytes) {
        this(new java.io.ByteArrayInputStream(bytes));
    }

    public int readInteger(int length) throws IOException {
        int result = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            result |= this.read() << (i2 << 3);
        }
        return result;
    }

    public long readLong(int length) throws IOException {
        long result = 0L;
        for (int i2 = 0; i2 < length; ++i2) {
            result |= (long)this.read() << (i2 << 3);
        }
        return result;
    }

    public String readString(int length) throws IOException {
        return new String(this.read(length));
    }

    public String readLengthEncodedString() throws IOException {
        return this.readString(this.readPackedInteger());
    }

    public String readZeroTerminatedString() throws IOException {
        int b2;
        ByteArrayOutputStream s2 = new ByteArrayOutputStream();
        while ((b2 = this.read()) != 0) {
            s2.writeInteger(b2, 1);
        }
        return new String(s2.toByteArray());
    }

    public byte[] read(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.fill(bytes, 0, length);
        return bytes;
    }

    public void fill(byte[] bytes, int offset, int length) throws IOException {
        int read;
        for (int remaining = length; remaining != 0; remaining -= read) {
            read = this.read(bytes, offset + length - remaining, remaining);
            if (read != -1) continue;
            throw new EOFException();
        }
    }

    public BitSet readBitSet(int length, boolean bigEndian) throws IOException {
        byte[] bytes = this.read(length + 7 >> 3);
        bytes = bigEndian ? bytes : this.reverse(bytes);
        BitSet result = new BitSet();
        for (int i2 = 0; i2 < length; ++i2) {
            if ((bytes[i2 >> 3] & 1 << i2 % 8) == 0) continue;
            result.set(i2);
        }
        return result;
    }

    private byte[] reverse(byte[] bytes) {
        int length = bytes.length >> 1;
        for (int i2 = 0; i2 < length; ++i2) {
            int j2 = bytes.length - 1 - i2;
            byte t = bytes[i2];
            bytes[i2] = bytes[j2];
            bytes[j2] = t;
        }
        return bytes;
    }

    public int readPackedInteger() throws IOException {
        Number number = this.readPackedNumber();
        if (number == null) {
            throw new IOException("Unexpected NULL where int should have been");
        }
        if (number.longValue() > Integer.MAX_VALUE) {
            throw new IOException("Stumbled upon long even though int expected");
        }
        return number.intValue();
    }

    public Number readPackedNumber() throws IOException {
        int b2 = this.read();
        if (b2 < 251) {
            return b2;
        }
        if (b2 == 251) {
            return null;
        }
        if (b2 == 252) {
            return (long)this.readInteger(2);
        }
        if (b2 == 253) {
            return (long)this.readInteger(3);
        }
        if (b2 == 254) {
            return this.readLong(8);
        }
        throw new IOException("Unexpected packed number byte " + b2);
    }

    @Override
    public int available() throws IOException {
        if (this.blockLength != -1) {
            return this.blockLength;
        }
        return this.inputStream.available();
    }

    public int peek() throws IOException {
        if (this.peek == null) {
            this.peek = this.readWithinBlockBoundaries();
        }
        return this.peek;
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.peek == null) {
            result = this.readWithinBlockBoundaries();
        } else {
            result = this.peek;
            this.peek = null;
        }
        if (result == -1) {
            throw new EOFException();
        }
        return result;
    }

    private int readWithinBlockBoundaries() throws IOException {
        if (this.blockLength != -1) {
            if (this.blockLength == 0) {
                return -1;
            }
            --this.blockLength;
        }
        return this.inputStream.read();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public void enterBlock(int length) {
        this.blockLength = length < -1 ? -1 : length;
    }

    public void skipToTheEndOfTheBlock() throws IOException {
        if (this.blockLength != -1) {
            this.skip(this.blockLength);
            this.blockLength = -1;
        }
    }
}

