/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStream
extends OutputStream {
    private OutputStream outputStream;

    public ByteArrayOutputStream() {
        this(new java.io.ByteArrayOutputStream());
    }

    public ByteArrayOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeInteger(int value, int length) throws IOException {
        for (int i2 = 0; i2 < length; ++i2) {
            this.write(0xFF & value >>> (i2 << 3));
        }
    }

    public void writeLong(long value, int length) throws IOException {
        for (int i2 = 0; i2 < length; ++i2) {
            this.write((int)(0xFFL & value >>> (i2 << 3)));
        }
    }

    public void writeString(String value) throws IOException {
        this.write(value.getBytes());
    }

    public void writeZeroTerminatedString(String value) throws IOException {
        this.write(value.getBytes());
        this.write(0);
    }

    @Override
    public void write(int b2) throws IOException {
        this.outputStream.write(b2);
    }

    public byte[] toByteArray() {
        if (this.outputStream instanceof java.io.ByteArrayOutputStream) {
            return ((java.io.ByteArrayOutputStream)this.outputStream).toByteArray();
        }
        return new byte[0];
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

