/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.network.protocol.command;

import com.github.shyiko.mysql.binlog.io.ByteArrayOutputStream;
import com.github.shyiko.mysql.binlog.network.protocol.command.Command;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AuthenticateCommand
implements Command {
    private String schema;
    private String username;
    private String password;
    private String salt;
    private int clientCapabilities;
    private int collation;

    public AuthenticateCommand(String schema, String username, String password, String salt) {
        this.schema = schema;
        this.username = username;
        this.password = password;
        this.salt = salt;
    }

    public void setClientCapabilities(int clientCapabilities) {
        this.clientCapabilities = clientCapabilities;
    }

    public void setCollation(int collation) {
        this.collation = collation;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int clientCapabilities = this.clientCapabilities;
        if (clientCapabilities == 0) {
            clientCapabilities = 33284;
            if (this.schema != null) {
                clientCapabilities |= 8;
            }
        }
        buffer.writeInteger(clientCapabilities, 4);
        buffer.writeInteger(0, 4);
        buffer.writeInteger(this.collation, 1);
        for (int i2 = 0; i2 < 23; ++i2) {
            buffer.write(0);
        }
        buffer.writeZeroTerminatedString(this.username);
        byte[] passwordSHA1 = "".equals(this.password) ? new byte[]{} : AuthenticateCommand.passwordCompatibleWithMySQL411(this.password, this.salt);
        buffer.writeInteger(passwordSHA1.length, 1);
        buffer.write(passwordSHA1);
        if (this.schema != null) {
            buffer.writeZeroTerminatedString(this.schema);
        }
        return buffer.toByteArray();
    }

    private static byte[] passwordCompatibleWithMySQL411(String password, String salt) {
        MessageDigest sha;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException(e2);
        }
        byte[] passwordHash = sha.digest(password.getBytes());
        return AuthenticateCommand.xor(passwordHash, sha.digest(AuthenticateCommand.union(salt.getBytes(), sha.digest(passwordHash))));
    }

    private static byte[] union(byte[] a2, byte[] b2) {
        byte[] r2 = new byte[a2.length + b2.length];
        System.arraycopy(a2, 0, r2, 0, a2.length);
        System.arraycopy(b2, 0, r2, a2.length, b2.length);
        return r2;
    }

    private static byte[] xor(byte[] a2, byte[] b2) {
        byte[] r2 = new byte[a2.length];
        for (int i2 = 0; i2 < r2.length; ++i2) {
            r2[i2] = (byte)(a2[i2] ^ b2[i2]);
        }
        return r2;
    }
}

