/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath;

import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.filter.FilterCompiler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public abstract class Filter
implements Predicate {
    public static Filter filter(Predicate predicate) {
        return new SingleFilter(predicate);
    }

    public static Filter filter(Collection<Predicate> predicates) {
        return new AndFilter(predicates);
    }

    @Override
    public abstract boolean apply(Predicate.PredicateContext var1);

    public Filter or(Predicate other) {
        return new OrFilter(this, other);
    }

    public Filter and(Predicate other) {
        return new AndFilter(this, other);
    }

    public static Filter parse(String filter) {
        return FilterCompiler.compile(filter);
    }

    private static final class OrFilter
    extends Filter {
        private final Predicate left;
        private final Predicate right;

        private OrFilter(Predicate left, Predicate right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Filter and(Predicate other) {
            return new OrFilter(this.left, new AndFilter(this.right, other));
        }

        @Override
        public boolean apply(Predicate.PredicateContext ctx) {
            boolean a2 = this.left.apply(ctx);
            return a2 || this.right.apply(ctx);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[?(");
            String l2 = this.left.toString();
            String r2 = this.right.toString();
            if (l2.startsWith("[?(")) {
                l2 = l2.substring(3, l2.length() - 2);
            }
            if (r2.startsWith("[?(")) {
                r2 = r2.substring(3, r2.length() - 2);
            }
            sb.append(l2).append(" || ").append(r2);
            sb.append(")]");
            return sb.toString();
        }
    }

    private static final class AndFilter
    extends Filter {
        private final Collection<Predicate> predicates;

        private AndFilter(Collection<Predicate> predicates) {
            this.predicates = predicates;
        }

        private AndFilter(Predicate left, Predicate right) {
            this(Arrays.asList(left, right));
        }

        @Override
        public Filter and(Predicate other) {
            ArrayList<Predicate> newPredicates = new ArrayList<Predicate>(this.predicates);
            newPredicates.add(other);
            return new AndFilter(newPredicates);
        }

        @Override
        public boolean apply(Predicate.PredicateContext ctx) {
            for (Predicate predicate : this.predicates) {
                if (predicate.apply(ctx)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            Iterator<Predicate> i2 = this.predicates.iterator();
            StringBuilder sb = new StringBuilder();
            sb.append("[?(");
            while (i2.hasNext()) {
                String p2 = i2.next().toString();
                if (p2.startsWith("[?(")) {
                    p2 = p2.substring(3, p2.length() - 2);
                }
                sb.append(p2);
                if (!i2.hasNext()) continue;
                sb.append(" && ");
            }
            sb.append(")]");
            return sb.toString();
        }
    }

    private static final class SingleFilter
    extends Filter {
        private final Predicate predicate;

        private SingleFilter(Predicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(Predicate.PredicateContext ctx) {
            return this.predicate.apply(ctx);
        }

        public String toString() {
            String predicateString = this.predicate.toString();
            if (predicateString.startsWith("(")) {
                return "[?" + predicateString + "]";
            }
            return "[?(" + predicateString + ")]";
        }
    }
}

