/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter;

import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.filter.Evaluator;
import com.jayway.jsonpath.internal.filter.EvaluatorFactory;
import com.jayway.jsonpath.internal.filter.ExpressionNode;
import com.jayway.jsonpath.internal.filter.RelationalOperator;
import com.jayway.jsonpath.internal.filter.ValueNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationalExpressionNode
extends ExpressionNode {
    private static final Logger logger = LoggerFactory.getLogger(RelationalExpressionNode.class);
    private final ValueNode left;
    private final RelationalOperator relationalOperator;
    private final ValueNode right;

    public RelationalExpressionNode(ValueNode left, RelationalOperator relationalOperator, ValueNode right) {
        this.left = left;
        this.relationalOperator = relationalOperator;
        this.right = right;
        logger.trace("ExpressionNode {}", (Object)this.toString());
    }

    public String toString() {
        if (this.relationalOperator == RelationalOperator.EXISTS) {
            return this.left.toString();
        }
        return this.left.toString() + " " + this.relationalOperator.toString() + " " + this.right.toString();
    }

    @Override
    public boolean apply(Predicate.PredicateContext ctx) {
        Evaluator evaluator;
        ValueNode l2 = this.left;
        ValueNode r2 = this.right;
        if (this.left.isPathNode()) {
            l2 = this.left.asPathNode().evaluate(ctx);
        }
        if (this.right.isPathNode()) {
            r2 = this.right.asPathNode().evaluate(ctx);
        }
        if ((evaluator = EvaluatorFactory.createEvaluator(this.relationalOperator)) != null) {
            return evaluator.evaluate(l2, r2, ctx);
        }
        return false;
    }
}

