/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.path;

import com.jayway.jsonpath.InvalidPathException;

public class ArraySliceOperation {
    private final Integer from;
    private final Integer to;
    private final Operation operation;

    private ArraySliceOperation(Integer from, Integer to, Operation operation) {
        this.from = from;
        this.to = to;
        this.operation = operation;
    }

    public Integer from() {
        return this.from;
    }

    public Integer to() {
        return this.to;
    }

    public Operation operation() {
        return this.operation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.from == null ? "" : this.from.toString());
        sb.append(":");
        sb.append(this.to == null ? "" : this.to.toString());
        sb.append("]");
        return sb.toString();
    }

    public static ArraySliceOperation parse(String operation) {
        Operation tempOperpation;
        for (int i2 = 0; i2 < operation.length(); ++i2) {
            char c2 = operation.charAt(i2);
            if (Character.isDigit(c2) || c2 == '-' || c2 == ':') continue;
            throw new InvalidPathException("Failed to parse SliceOperation: " + operation);
        }
        String[] tokens = operation.split(":");
        Integer tempFrom = ArraySliceOperation.tryRead(tokens, 0);
        Integer tempTo = ArraySliceOperation.tryRead(tokens, 1);
        if (tempFrom != null && tempTo == null) {
            tempOperpation = Operation.SLICE_FROM;
        } else if (tempFrom != null && tempTo != null) {
            tempOperpation = Operation.SLICE_BETWEEN;
        } else if (tempFrom == null && tempTo != null) {
            tempOperpation = Operation.SLICE_TO;
        } else {
            throw new InvalidPathException("Failed to parse SliceOperation: " + operation);
        }
        return new ArraySliceOperation(tempFrom, tempTo, tempOperpation);
    }

    private static Integer tryRead(String[] tokens, int idx) {
        if (tokens.length > idx) {
            if (tokens[idx].equals("")) {
                return null;
            }
            return Integer.parseInt(tokens[idx]);
        }
        return null;
    }

    public static enum Operation {
        SLICE_FROM,
        SLICE_TO,
        SLICE_BETWEEN;

    }
}

