/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.mask.Mask;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(AuditHandler.class);
    public static final String CONFIG_NAME = "audit";
    public static final String ENABLED = "enabled";
    static final String HEADERS = "headers";
    static final String AUDIT = "audit";
    static final String STATUS_CODE = "statusCode";
    static final String RESPONSE_TIME = "responseTime";
    static final String TIMESTAMP = "timestamp";
    static final String AUDIT_ON_ERROR = "auditOnError";
    static final String IS_LOG_LEVEL_ERROR = "logLevelIsError";
    static final String IS_MASK_ENABLED = "mask";
    static final String MASK_KEY = "audit";
    public static final Map<String, Object> config;
    private static final List<String> headerList;
    private static final List<String> auditList;
    private static boolean statusCode;
    private static boolean responseTime;
    private static boolean auditOnError;
    private static boolean isMaskEnabled;
    static Consumer<String> auditFunc;
    public static final AttachmentKey<Map> AUDIT_INFO;
    private volatile HttpHandler next;

    public AuditHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("AuditHandler is loaded.");
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Object value;
        Map auditInfo = exchange.getAttachment(AUDIT_INFO);
        LinkedHashMap<String, Object> auditMap = new LinkedHashMap<String, Object>();
        long start = System.currentTimeMillis();
        auditMap.put(TIMESTAMP, System.currentTimeMillis());
        if (auditInfo != null && auditList != null && auditList.size() > 0) {
            for (String name : auditList) {
                value = auditInfo.get(name);
                if (isMaskEnabled && value instanceof String) {
                    auditMap.put(name, Mask.maskRegex((String)value, "audit", name));
                    continue;
                }
                auditMap.put(name, value);
            }
        }
        if (headerList != null && headerList.size() > 0) {
            for (String name : headerList) {
                value = exchange.getRequestHeaders().getFirst(name);
                if (isMaskEnabled) {
                    auditMap.put(name, Mask.maskRegex(value, "requestHeader", name));
                    continue;
                }
                auditMap.put(name, value);
            }
        }
        if (statusCode || responseTime) {
            exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
                if (statusCode) {
                    auditMap.put(STATUS_CODE, exchange1.getStatusCode());
                }
                if (responseTime) {
                    auditMap.put(RESPONSE_TIME, System.currentTimeMillis() - start);
                }
                if (auditInfo != null && auditList != null && auditList.size() > 0) {
                    for (String name : auditList) {
                        auditMap.putIfAbsent(name, auditInfo.get(name));
                    }
                }
                try {
                    if (auditOnError) {
                        if (exchange1.getStatusCode() >= 400) {
                            auditFunc.accept(Config.getInstance().getMapper().writeValueAsString(auditMap));
                        }
                    } else {
                        auditFunc.accept(Config.getInstance().getMapper().writeValueAsString(auditMap));
                    }
                }
                catch (JsonProcessingException e2) {
                    throw new RuntimeException(e2);
                }
                nextListener.proceed();
            });
        } else {
            auditFunc.accept(Config.getInstance().getMapper().writeValueAsString(auditMap));
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        Object object = config.get(ENABLED);
        return object != null && (Boolean)object != false;
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(AuditHandler.class.getName(), config, null);
    }

    static {
        statusCode = false;
        responseTime = false;
        auditOnError = false;
        isMaskEnabled = false;
        auditFunc = LoggerFactory.getLogger("Audit")::info;
        AUDIT_INFO = AttachmentKey.create(Map.class);
        config = Config.getInstance().getJsonMapConfigNoCache("audit");
        headerList = (List)config.get(HEADERS);
        auditList = (List)config.get("audit");
        Object object = config.get(STATUS_CODE);
        if (object != null && ((Boolean)object).booleanValue()) {
            statusCode = true;
        }
        if ((object = config.get(RESPONSE_TIME)) != null && ((Boolean)object).booleanValue()) {
            responseTime = true;
        }
        if ((object = config.get(AUDIT_ON_ERROR)) != null && ((Boolean)object).booleanValue()) {
            auditOnError = true;
        }
        auditFunc = (object = config.get(IS_LOG_LEVEL_ERROR)) != null && ((Boolean)object).booleanValue() ? LoggerFactory.getLogger("Audit")::error : LoggerFactory.getLogger("Audit")::info;
        object = config.get(IS_MASK_ENABLED);
        if (object != null && ((Boolean)object).booleanValue()) {
            isMaskEnabled = true;
        }
    }
}

