/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.balance;

import com.networknt.balance.RoundRobinLoadBalance;
import com.networknt.registry.URL;
import com.networknt.utility.Util;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFirstLoadBalance
extends RoundRobinLoadBalance {
    static Logger logger = LoggerFactory.getLogger(LocalFirstLoadBalance.class);
    static String ip = "0.0.0.0";

    public LocalFirstLoadBalance() {
        if (logger.isInfoEnabled()) {
            logger.info("A LocalFirstLoadBalance instance is started");
        }
    }

    @Override
    public URL select(List<URL> urls, String requestKey) {
        List<URL> localUrls = this.searchLocalUrls(urls, ip);
        if (localUrls.size() > 0) {
            if (localUrls.size() == 1) {
                return localUrls.get(0);
            }
            return this.doSelect(localUrls);
        }
        return this.doSelect(urls);
    }

    private List<URL> searchLocalUrls(List<URL> urls, String ip) {
        ArrayList<URL> localUrls = new ArrayList<URL>();
        long local = LocalFirstLoadBalance.ipToLong(ip);
        for (URL url : urls) {
            long tmp = LocalFirstLoadBalance.ipToLong(url.getHost());
            if (local == 0L || local != tmp) continue;
            localUrls.add(url);
        }
        return localUrls;
    }

    public static long ipToLong(String address) {
        String[] addressBytes = address.split("\\.");
        int length = addressBytes.length;
        if (length < 3) {
            return 0L;
        }
        long ip = 0L;
        try {
            for (int i2 = 0; i2 < 4; ++i2) {
                ip <<= 8;
                ip |= (long)Integer.parseInt(addressBytes[i2]);
            }
        }
        catch (Exception e2) {
            logger.warn("Warn ipToLong address is wrong: address =" + address);
        }
        return ip;
    }

    static {
        InetAddress inetAddress = Util.getInetAddress();
        ip = inetAddress.getHostAddress();
    }
}

