/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import java.util.Map;

public class DerefRequest {
    public static String OAUTH = "oauth";
    public static String DEREF = "deref";
    public static String SERVER_URL = "server_url";
    public static String URI = "uri";
    public static String CLIENT_ID = "client_id";
    public static String ENABLE_HTTP2 = "enableHttp2";
    static Map<String, Object> secret = DecryptUtil.decryptMap(Config.getInstance().getJsonMapConfig("secret"));
    String serverUrl;
    String uri;
    String clientId;
    String clientSecret;
    boolean enableHttp2;

    public DerefRequest(String token) {
        Map derefConfig;
        Map oauthConfig;
        Map<String, Object> clientConfig = Config.getInstance().getJsonMapConfig("client");
        if (clientConfig != null && (oauthConfig = (Map)clientConfig.get(OAUTH)) != null && (derefConfig = (Map)oauthConfig.get(DEREF)) != null) {
            this.setServerUrl((String)derefConfig.get(SERVER_URL));
            Object object = derefConfig.get(ENABLE_HTTP2);
            this.setEnableHttp2(object != null && (Boolean)object != false);
            this.setUri(derefConfig.get(URI) + "/" + token);
            this.setClientId((String)derefConfig.get(CLIENT_ID));
            this.setClientSecret((String)secret.get("derefClientSecret"));
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public boolean isEnableHttp2() {
        return this.enableHttp2;
    }

    public void setEnableHttp2(boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
    }
}

