/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.config.Config;
import java.util.Map;

public class Jwt {
    private String jwt;
    private long expire;
    private volatile boolean renewing = false;
    private volatile long expiredRetryTimeout;
    private volatile long earlyRetryTimeout;
    private static long tokenRenewBeforeExpired;
    private static long expiredRefreshRetryDelay;
    private static long earlyRefreshRetryDelay;
    static final String OAUTH = "oauth";
    static final String TOKEN = "token";
    static final String TOKEN_RENEW_BEFORE_EXPIRED = "tokenRenewBeforeExpired";
    static final String EXPIRED_REFRESH_RETRY_DELAY = "expiredRefreshRetryDelay";
    static final String EARLY_REFRESH_RETRY_DELAY = "earlyRefreshRetryDelay";
    public static final String CLIENT_CONFIG_NAME = "client";

    public Jwt() {
        Map oauthConfig;
        Map<String, Object> clientConfig = Config.getInstance().getJsonMapConfig(CLIENT_CONFIG_NAME);
        if (clientConfig != null && (oauthConfig = (Map)clientConfig.get(OAUTH)) != null) {
            Map tokenConfig = (Map)oauthConfig.get(TOKEN);
            tokenRenewBeforeExpired = ((Integer)tokenConfig.get(TOKEN_RENEW_BEFORE_EXPIRED)).intValue();
            expiredRefreshRetryDelay = ((Integer)tokenConfig.get(EXPIRED_REFRESH_RETRY_DELAY)).intValue();
            earlyRefreshRetryDelay = ((Integer)tokenConfig.get(EARLY_REFRESH_RETRY_DELAY)).intValue();
        }
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public boolean isRenewing() {
        return this.renewing;
    }

    public void setRenewing(boolean renewing) {
        this.renewing = renewing;
    }

    public long getExpiredRetryTimeout() {
        return this.expiredRetryTimeout;
    }

    public void setExpiredRetryTimeout(long expiredRetryTimeout) {
        this.expiredRetryTimeout = expiredRetryTimeout;
    }

    public long getEarlyRetryTimeout() {
        return this.earlyRetryTimeout;
    }

    public void setEarlyRetryTimeout(long earlyRetryTimeout) {
        this.earlyRetryTimeout = earlyRetryTimeout;
    }

    public static long getTokenRenewBeforeExpired() {
        return tokenRenewBeforeExpired;
    }

    public static void setTokenRenewBeforeExpired(long tokenRenewBeforeExpired) {
        Jwt.tokenRenewBeforeExpired = tokenRenewBeforeExpired;
    }

    public static long getExpiredRefreshRetryDelay() {
        return expiredRefreshRetryDelay;
    }

    public static void setExpiredRefreshRetryDelay(long expiredRefreshRetryDelay) {
        Jwt.expiredRefreshRetryDelay = expiredRefreshRetryDelay;
    }

    public static long getEarlyRefreshRetryDelay() {
        return earlyRefreshRetryDelay;
    }

    public static void setEarlyRefreshRetryDelay(long earlyRefreshRetryDelay) {
        Jwt.earlyRefreshRetryDelay = earlyRefreshRetryDelay;
    }
}

