/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.networknt.client.Http2Client;
import com.networknt.client.oauth.AuthorizationCodeRequest;
import com.networknt.client.oauth.ClientCredentialsRequest;
import com.networknt.client.oauth.DerefRequest;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.KeyRequest;
import com.networknt.client.oauth.RefreshTokenRequest;
import com.networknt.client.oauth.SAMLBearerRequest;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.config.Config;
import com.networknt.exception.ClientException;
import com.networknt.httpstring.ContentType;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.status.Status;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import io.undertow.util.StringWriteChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class OauthHelper {
    static final String BASIC = "Basic";
    static final String GRANT_TYPE = "grant_type";
    static final String CODE = "code";
    private static final String FAIL_TO_SEND_REQUEST = "ERR10051";
    private static final String GET_TOKEN_ERROR = "ERR10052";
    private static final String ESTABLISH_CONNECTION_ERROR = "ERR10053";
    private static final String GET_TOKEN_TIMEOUT = "ERR10054";
    public static final String STATUS_CLIENT_CREDENTIALS_TOKEN_NOT_AVAILABLE = "ERR10009";
    static final Logger logger = LoggerFactory.getLogger(OauthHelper.class);

    @Deprecated
    public static TokenResponse getToken(TokenRequest tokenRequest) throws ClientException {
        Result<TokenResponse> responseResult = OauthHelper.getTokenResult(tokenRequest);
        if (responseResult.isSuccess()) {
            return responseResult.getResult();
        }
        throw new ClientException(responseResult.getError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<TokenResponse> getTokenResult(TokenRequest tokenRequest) {
        ClientConnection connection;
        final AtomicReference reference = new AtomicReference();
        Http2Client client = Http2Client.getInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            connection = client.connect(new URI(tokenRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, tokenRequest.enableHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY).get();
        }
        catch (Exception e2) {
            logger.error("cannot establish connection: {}", e2.getStackTrace());
            return Failure.of(new Status(ESTABLISH_CONNECTION_ERROR, tokenRequest.getServerUrl()));
        }
        try {
            final String requestBody = OauthHelper.getEncodedString(tokenRequest);
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(tokenRequest.getUri());
                request.getRequestHeaders().put(Headers.HOST, "localhost");
                request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                request.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/x-www-form-urlencoded");
                request.getRequestHeaders().put(Headers.AUTHORIZATION, OauthHelper.getBasicAuthHeader(tokenRequest.getClientId(), tokenRequest.getClientSecret()));
                connection.sendRequest(request, new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(ClientExchange result) {
                        new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                        result.setResponseListener(new ClientCallback<ClientExchange>(){

                            @Override
                            public void completed(final ClientExchange result) {
                                new StringReadChannelListener(Http2Client.BUFFER_POOL){

                                    @Override
                                    protected void stringDone(String string) {
                                        logger.debug("getToken response = " + string);
                                        reference.set(OauthHelper.handleResponse(OauthHelper.getContentTypeFromExchange(result), string));
                                        latch.countDown();
                                    }

                                    @Override
                                    protected void error(IOException e2) {
                                        logger.error("IOException:", e2);
                                        reference.set(Failure.of(new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                                        latch.countDown();
                                    }
                                }.setup(result.getResponseChannel());
                            }

                            @Override
                            public void failed(IOException e2) {
                                logger.error("IOException:", e2);
                                reference.set(Failure.of(new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                                latch.countDown();
                            }
                        });
                    }

                    @Override
                    public void failed(IOException e2) {
                        logger.error("IOException:", e2);
                        reference.set(Failure.of(new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                        latch.countDown();
                    }
                });
            });
            latch.await(4L, TimeUnit.SECONDS);
        }
        catch (Exception e3) {
            logger.error("IOException: ", e3);
            Result<TokenResponse> result = Failure.of(new Status(FAIL_TO_SEND_REQUEST, new Object[0]));
            return result;
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return reference.get() == null ? Failure.of(new Status(GET_TOKEN_TIMEOUT, new Object[0])) : (Result)reference.get();
    }

    @Deprecated
    public static TokenResponse getTokenFromSaml(SAMLBearerRequest tokenRequest) throws ClientException {
        Result<TokenResponse> responseResult = OauthHelper.getTokenFromSamlResult(tokenRequest);
        if (responseResult.isSuccess()) {
            return responseResult.getResult();
        }
        throw new ClientException(responseResult.getError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<TokenResponse> getTokenFromSamlResult(SAMLBearerRequest tokenRequest) {
        ClientConnection connection;
        final AtomicReference reference = new AtomicReference();
        Http2Client client = Http2Client.getInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            connection = client.connect(new URI(tokenRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, tokenRequest.enableHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY).get();
        }
        catch (Exception e2) {
            logger.error("cannot establish connection: {}", e2.getStackTrace());
            return Failure.of(new Status(ESTABLISH_CONNECTION_ERROR, new Object[0]));
        }
        try {
            HashMap<String, String> postBody = new HashMap<String, String>();
            postBody.put(GRANT_TYPE, "urn:ietf:params:oauth:grant-type:saml2-bearer");
            postBody.put("assertion", tokenRequest.getSamlAssertion());
            postBody.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            postBody.put("client_assertion", tokenRequest.getJwtClientAssertion());
            final String requestBody = Http2Client.getFormDataString(postBody);
            logger.debug(requestBody);
            connection.getIoThread().execute(() -> {
                ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(tokenRequest.getUri());
                request.getRequestHeaders().put(Headers.HOST, "localhost");
                request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
                request.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/x-www-form-urlencoded");
                connection.sendRequest(request, new ClientCallback<ClientExchange>(){

                    @Override
                    public void completed(ClientExchange result) {
                        new StringWriteChannelListener(requestBody).setup(result.getRequestChannel());
                        result.setResponseListener(new ClientCallback<ClientExchange>(){

                            @Override
                            public void completed(final ClientExchange result) {
                                new StringReadChannelListener(Http2Client.BUFFER_POOL){

                                    @Override
                                    protected void stringDone(String string) {
                                        logger.debug("getToken response = " + string);
                                        reference.set(OauthHelper.handleResponse(OauthHelper.getContentTypeFromExchange(result), string));
                                        latch.countDown();
                                    }

                                    @Override
                                    protected void error(IOException e2) {
                                        logger.error("IOException:", e2);
                                        reference.set(Failure.of(new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                                        latch.countDown();
                                    }
                                }.setup(result.getResponseChannel());
                            }

                            @Override
                            public void failed(IOException e2) {
                                logger.error("IOException:", e2);
                                reference.set(Failure.of(new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                                latch.countDown();
                            }
                        });
                    }

                    @Override
                    public void failed(IOException e2) {
                        logger.error("IOException:", e2);
                        reference.set(Failure.of(new Status(OauthHelper.FAIL_TO_SEND_REQUEST, new Object[0])));
                        latch.countDown();
                    }
                });
            });
            latch.await(4L, TimeUnit.SECONDS);
        }
        catch (Exception e3) {
            logger.error("IOException: ", e3);
            Result<TokenResponse> result = Failure.of(new Status(FAIL_TO_SEND_REQUEST, new Object[0]));
            return result;
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return reference.get() == null ? Failure.of(new Status(GET_TOKEN_TIMEOUT, new Object[0])) : (Result)reference.get();
    }

    public static String getKey(KeyRequest keyRequest) throws ClientException {
        ClientConnection connection;
        Http2Client client = Http2Client.getInstance();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            connection = client.connect(new URI(keyRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, keyRequest.enableHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY).get();
        }
        catch (Exception e2) {
            throw new ClientException(e2);
        }
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            ClientRequest request = new ClientRequest().setPath(keyRequest.getUri()).setMethod(Methods.GET);
            if (keyRequest.getClientId() != null) {
                request.getRequestHeaders().put(Headers.AUTHORIZATION, OauthHelper.getBasicAuthHeader(keyRequest.getClientId(), keyRequest.getClientSecret()));
            }
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
        }
        catch (Exception e3) {
            logger.error("Exception: ", e3);
            throw new ClientException(e3);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return reference.get().getAttachment(Http2Client.RESPONSE_BODY);
    }

    public static String derefToken(DerefRequest derefRequest) throws ClientException {
        ClientConnection connection;
        Http2Client client = Http2Client.getInstance();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            connection = client.connect(new URI(derefRequest.getServerUrl()), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, derefRequest.enableHttp2 ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY).get();
        }
        catch (Exception e2) {
            throw new ClientException(e2);
        }
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            ClientRequest request = new ClientRequest().setPath(derefRequest.getUri()).setMethod(Methods.GET);
            request.getRequestHeaders().put(Headers.AUTHORIZATION, OauthHelper.getBasicAuthHeader(derefRequest.getClientId(), derefRequest.getClientSecret()));
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
        }
        catch (Exception e3) {
            logger.error("Exception: ", e3);
            throw new ClientException(e3);
        }
        finally {
            IoUtils.safeClose((Closeable)connection);
        }
        return reference.get().getAttachment(Http2Client.RESPONSE_BODY);
    }

    public static String getBasicAuthHeader(String clientId, String clientSecret) {
        return "Basic " + OauthHelper.encodeCredentials(clientId, clientSecret);
    }

    public static String encodeCredentials(String clientId, String clientSecret) {
        String cred = clientSecret != null ? clientId + ":" + clientSecret : clientId;
        byte[] encodedBytes = Base64.encodeBase64(cred.getBytes(StandardCharsets.UTF_8));
        String encodedValue = new String(encodedBytes, StandardCharsets.UTF_8);
        return encodedValue;
    }

    private static String getEncodedString(TokenRequest request) throws UnsupportedEncodingException {
        String csrf;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GRANT_TYPE, request.getGrantType());
        if (TokenRequest.AUTHORIZATION_CODE.equals(request.getGrantType())) {
            params.put(CODE, ((AuthorizationCodeRequest)request).getAuthCode());
            params.put(TokenRequest.REDIRECT_URI, ((AuthorizationCodeRequest)request).getRedirectUri());
            csrf = request.getCsrf();
            if (csrf != null) {
                params.put(TokenRequest.CSRF, csrf);
            }
        }
        if (TokenRequest.REFRESH_TOKEN.equals(request.getGrantType())) {
            params.put(TokenRequest.REFRESH_TOKEN, ((RefreshTokenRequest)request).getRefreshToken());
            csrf = request.getCsrf();
            if (csrf != null) {
                params.put(TokenRequest.CSRF, csrf);
            }
        }
        if (request.getScope() != null) {
            params.put(TokenRequest.SCOPE, String.join((CharSequence)" ", request.getScope()));
        }
        return Http2Client.getFormDataString(params);
    }

    private static Result<TokenResponse> handleResponse(ContentType contentType, String responseBody) {
        Result<TokenResponse> result;
        try {
            if (!contentType.equals((Object)ContentType.APPLICATION_JSON)) {
                return Failure.of(new Status(GET_TOKEN_ERROR, OauthHelper.escapeBasedOnType(contentType, responseBody)));
            }
            if (responseBody != null && responseBody.length() > 0) {
                TokenResponse tokenResponse = Config.getInstance().getMapper().readValue(responseBody, TokenResponse.class);
                result = tokenResponse != null ? Success.of(tokenResponse) : Failure.of(new Status(GET_TOKEN_ERROR, responseBody));
            } else {
                result = Failure.of(new Status(GET_TOKEN_ERROR, "no auth server response"));
                logger.error("Error in token retrieval, response = " + responseBody);
            }
        }
        catch (UnrecognizedPropertyException e2) {
            result = Failure.of(new Status(GET_TOKEN_ERROR, OauthHelper.escapeBasedOnType(contentType, responseBody)));
        }
        catch (IOException | RuntimeException e3) {
            result = Failure.of(new Status(GET_TOKEN_ERROR, e3.getMessage()));
            logger.error("Error in token retrieval", e3);
        }
        return result;
    }

    public static void sendStatusToResponse(HttpServerExchange exchange, Status status) {
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseSender().send(status.toString());
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        logger.error(status.toString() + " at " + elements[2].getClassName() + "." + elements[2].getMethodName() + "(" + elements[2].getFileName() + ":" + elements[2].getLineNumber() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<Jwt> populateCCToken(Jwt jwt) {
        boolean isInRenewWindow = jwt.getExpire() - System.currentTimeMillis() < jwt.getTokenRenewBeforeExpired();
        logger.trace("isInRenewWindow = " + isInRenewWindow);
        if (!isInRenewWindow) {
            return Success.of(jwt);
        }
        Class<OauthHelper> clazz = OauthHelper.class;
        synchronized (OauthHelper.class) {
            if (jwt.getExpire() <= System.currentTimeMillis()) {
                Result<Jwt> result = OauthHelper.renewCCTokenSync(jwt);
                if (logger.isTraceEnabled()) {
                    logger.trace("Check secondary token is done!");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            OauthHelper.renewCCTokenAsync(jwt);
            if (logger.isTraceEnabled()) {
                logger.trace("Check secondary token is done!");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Success.of(jwt);
        }
    }

    private static Result<Jwt> renewCCTokenSync(Jwt jwt) {
        logger.trace("In renew window and token is already expired.");
        if (!jwt.isRenewing() || System.currentTimeMillis() > jwt.getExpiredRetryTimeout()) {
            jwt.setRenewing(true);
            jwt.setEarlyRetryTimeout(System.currentTimeMillis() + jwt.getExpiredRefreshRetryDelay());
            Result<Jwt> result = OauthHelper.getCCTokenRemotely(jwt);
            jwt.setRenewing(false);
            return result;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Circuit breaker is tripped and not timeout yet!");
        }
        return Failure.of(new Status(STATUS_CLIENT_CREDENTIALS_TOKEN_NOT_AVAILABLE, new Object[0]));
    }

    private static void renewCCTokenAsync(Jwt jwt) {
        logger.trace("In renew window but token is not expired yet.");
        if (!jwt.isRenewing() || System.currentTimeMillis() > jwt.getEarlyRetryTimeout()) {
            jwt.setRenewing(true);
            jwt.setEarlyRetryTimeout(System.currentTimeMillis() + jwt.getEarlyRefreshRetryDelay());
            logger.trace("Retrieve token async is called while token is not expired yet");
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.schedule(() -> {
                Result<Jwt> result = OauthHelper.getCCTokenRemotely(jwt);
                if (result.isFailure()) {
                    logger.error("Async retrieve token error with status: {}", (Object)result.getError().toString());
                }
                jwt.setRenewing(false);
            }, 50L, TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
    }

    private static Result<Jwt> getCCTokenRemotely(Jwt jwt) {
        ClientCredentialsRequest tokenRequest = new ClientCredentialsRequest();
        Result<TokenResponse> result = OauthHelper.getTokenResult(tokenRequest);
        if (result.isSuccess()) {
            TokenResponse tokenResponse = result.getResult();
            jwt.setJwt(tokenResponse.getAccessToken());
            jwt.setExpire(System.currentTimeMillis() + tokenResponse.getExpiresIn() * 1000L);
            logger.info("Get client credentials token {} with expire_in {} seconds", (Object)jwt, (Object)tokenResponse.getExpiresIn());
            return Success.of(jwt);
        }
        logger.info("Get client credentials token fail with status: {}", (Object)result.getError().toString());
        return Failure.of(result.getError());
    }

    public static ContentType getContentTypeFromExchange(ClientExchange exchange) {
        HeaderValues headerValues = exchange.getResponse().getResponseHeaders().get(Headers.CONTENT_TYPE);
        return headerValues == null ? ContentType.ANY_TYPE : ContentType.toContentType(headerValues.getFirst());
    }

    private static String escapeBasedOnType(ContentType contentType, String responseBody) {
        switch (contentType) {
            case APPLICATION_JSON: {
                try {
                    String escapedStr = Config.getInstance().getMapper().writeValueAsString(responseBody);
                    return escapedStr.substring(1, escapedStr.length() - 1);
                }
                catch (JsonProcessingException e2) {
                    logger.error("escape json response fails");
                    return responseBody;
                }
            }
            case XML: {
                return OauthHelper.escapeXml(responseBody);
            }
        }
        return responseBody;
    }

    private static String escapeXml(String nonEscapedXmlStr) {
        StringBuilder escapedXML = new StringBuilder();
        block7: for (int i2 = 0; i2 < nonEscapedXmlStr.length(); ++i2) {
            char c2 = nonEscapedXmlStr.charAt(i2);
            switch (c2) {
                case '<': {
                    escapedXML.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escapedXML.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    escapedXML.append("&quot;");
                    continue block7;
                }
                case '&': {
                    escapedXML.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    escapedXML.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c2 > '~') {
                        escapedXML.append("&#" + c2 + ";");
                        continue block7;
                    }
                    escapedXML.append(c2);
                }
            }
        }
        return escapedXML.toString();
    }
}

