/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.oauth.TokenRequest;
import com.networknt.config.Config;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLBearerRequest
extends TokenRequest {
    static final String CLIENT_ASSERTION_TYPE_KEY = "client_assertion_type";
    static final String CLIENT_ASSERTION_TYPE_VALUE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    static final String CLIENT_ASSERTION_KEY = "client_assertion";
    static final String ASSERTION_KEY = "assertion";
    static final String GRANT_TYPE_KEY = "grant_type";
    static final String GRANT_TYPE_VALUE = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    private String samlAssertion;
    private String jwtClientAssertion;
    static Map<String, Object> clientConfig = Config.getInstance().getJsonMapConfig("client");
    static final Logger logger = LoggerFactory.getLogger(SAMLBearerRequest.class);

    public SAMLBearerRequest(String samlAssertion, String jwtClientAssertion) {
        this.setGrantType(SAML_BEARER);
        this.samlAssertion = samlAssertion;
        this.jwtClientAssertion = jwtClientAssertion;
        try {
            Map oauthConfig = (Map)clientConfig.get(OAUTH);
            Map tokenConfig = (Map)oauthConfig.get(TOKEN);
            this.setServerUrl((String)tokenConfig.get(SERVER_URL));
            Object object = tokenConfig.get(ENABLE_HTTP2);
            this.setEnableHttp2(object != null && (Boolean)object != false);
            Map ccConfig = (Map)tokenConfig.get(CLIENT_CREDENTIALS);
            this.setClientId((String)ccConfig.get(CLIENT_ID));
            this.setUri((String)ccConfig.get(URI));
        }
        catch (NullPointerException e2) {
            logger.error("Nullpointer in config object: " + e2);
        }
    }

    public String getSamlAssertion() {
        return this.samlAssertion;
    }

    public String getJwtClientAssertion() {
        return this.jwtClientAssertion;
    }
}

