/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.ssl;

import com.networknt.client.ssl.APINameChecker;
import com.networknt.client.ssl.EndpointIdentificationAlgorithm;
import com.networknt.client.ssl.SSLUtils;
import com.networknt.client.ssl.TLSConfig;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public class ClientX509ExtendedTrustManager
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final X509TrustManager trustManager;
    private final EndpointIdentificationAlgorithm identityAlg;
    private final Set<String> trustedNameSet = new HashSet<String>();

    public ClientX509ExtendedTrustManager(X509TrustManager trustManager, TLSConfig tlsConfig) {
        this.trustManager = Objects.requireNonNull(trustManager);
        this.identityAlg = tlsConfig.getEndpointIdentificationAlgorithm();
        this.trustedNameSet.addAll(tlsConfig.getTrustedNameSet());
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkClientTrusted(chain, authType, (Socket)null);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkServerTrusted(chain, authType, (Socket)null);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            EndpointIdentificationAlgorithm.setup(socket, this.identityAlg);
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)this.trustManager).checkClientTrusted(chain, authType, socket);
            } else {
                this.trustManager.checkClientTrusted(chain, authType);
                this.checkIdentity(socket, chain[0]);
            }
        }
        catch (Throwable t) {
            SSLUtils.handleTrustValidationErrors(t);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        try {
            EndpointIdentificationAlgorithm.setup(socket, this.identityAlg);
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)this.trustManager).checkServerTrusted(chain, authType, socket);
            } else {
                this.trustManager.checkServerTrusted(chain, authType);
                this.checkIdentity(socket, chain[0]);
            }
            this.doCustomServerIdentityCheck(chain[0]);
        }
        catch (Throwable t) {
            SSLUtils.handleTrustValidationErrors(t);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            EndpointIdentificationAlgorithm.setup(engine, this.identityAlg);
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)this.trustManager).checkClientTrusted(chain, authType, engine);
            } else {
                this.trustManager.checkClientTrusted(chain, authType);
                this.checkIdentity(engine, chain[0]);
            }
        }
        catch (Throwable t) {
            SSLUtils.handleTrustValidationErrors(t);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        try {
            EndpointIdentificationAlgorithm.setup(engine, this.identityAlg);
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)this.trustManager).checkServerTrusted(chain, authType, engine);
            } else {
                this.trustManager.checkServerTrusted(chain, authType);
                this.checkIdentity(engine, chain[0]);
            }
            this.doCustomServerIdentityCheck(chain[0]);
        }
        catch (Throwable t) {
            SSLUtils.handleTrustValidationErrors(t);
        }
    }

    private void doCustomServerIdentityCheck(X509Certificate cert) throws CertificateException {
        if (EndpointIdentificationAlgorithm.APIS == this.identityAlg) {
            APINameChecker.verifyAndThrow(this.trustedNameSet, cert);
        }
    }

    private void checkIdentity(SSLEngine engine, X509Certificate cert) throws CertificateException {
        if (null != engine) {
            SSLSession session = engine.getHandshakeSession();
            this.checkIdentity(session, cert);
        }
    }

    private void checkIdentity(Socket socket, X509Certificate cert) throws CertificateException {
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession session = sslSocket.getHandshakeSession();
            this.checkIdentity(session, cert);
        }
    }

    private void checkIdentity(SSLSession session, X509Certificate cert) throws CertificateException {
        if (session == null) {
            throw new CertificateException("No handshake session");
        }
        if (EndpointIdentificationAlgorithm.HTTPS == this.identityAlg) {
            String hostname = session.getPeerHost();
            APINameChecker.verifyAndThrow(hostname, cert);
        }
    }

    public static TrustManager[] decorate(TrustManager[] trustManagers, TLSConfig tlsConfig) {
        if (null != trustManagers && trustManagers.length > 0) {
            TrustManager[] decoratedTrustManagers = new TrustManager[trustManagers.length];
            for (int i2 = 0; i2 < trustManagers.length; ++i2) {
                TrustManager trustManager = trustManagers[i2];
                decoratedTrustManagers[i2] = trustManager instanceof X509TrustManager ? new ClientX509ExtendedTrustManager((X509TrustManager)trustManager, tlsConfig) : trustManager;
            }
            return decoratedTrustManagers;
        }
        return trustManagers;
    }
}

