/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config;

import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigInjection {
    private static final String INJECTION_ORDER = "injection_order";
    private static final String INJECTION_ORDER_CODE = !System.getProperty("injection_order", "").equals("") ? System.getProperty("injection_order", "") : "2";
    private static final String CENTRALIZED_MANAGEMENT = "values";
    private static final String SCALABLE_CONFIG = "config";
    private static final String EXCLUSION_CONFIG_FILE_LIST = "exclusionConfigFileList";
    private static final Map<String, Object> valueMap = Config.getInstance().getJsonMapConfig("values");
    private static final Map<String, Object> exclusionMap = Config.getInstance().getJsonMapConfig("config");
    private static Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
    private static String[] trueArray = new String[]{"y", "Y", "yes", "Yes", "YES", "true", "True", "TRUE", "on", "On", "ON"};
    private static String[] falseArray = new String[]{"n", "N", "no", "No", "NO", "false", "False", "FALSE", "off", "Off", "OFF"};

    public static Object getInjectValue(String string) {
        Matcher m2 = pattern.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (m2.find()) {
            Object value = ConfigInjection.getValue(m2.group(1));
            if (!(value instanceof String)) {
                return value;
            }
            m2.appendReplacement(sb, (String)value);
        }
        return m2.appendTail(sb).toString();
    }

    public static boolean isExclusionConfigFile(String configName) {
        List exclusionConfigFileList = exclusionMap == null ? new ArrayList() : (List)exclusionMap.get(EXCLUSION_CONFIG_FILE_LIST);
        return CENTRALIZED_MANAGEMENT.equals(configName) || SCALABLE_CONFIG.equals(configName) || exclusionConfigFileList.contains(configName);
    }

    private static Object getValue(String content) {
        InjectionPattern injectionPattern = ConfigInjection.getInjectionPattern(content);
        Object value = null;
        if (injectionPattern != null) {
            String error_text;
            Object envValue = ConfigInjection.typeCast(System.getenv(injectionPattern.getKey()));
            Object fileValue = valueMap != null ? valueMap.get(injectionPattern.getKey()) : null;
            value = INJECTION_ORDER_CODE.equals("2") && envValue != null || INJECTION_ORDER_CODE.equals("1") && fileValue == null ? envValue : fileValue;
            if (!(value != null && !value.equals("") || (value = ConfigInjection.typeCast(injectionPattern.getDefaultValue())) != null && !value.equals("") || (error_text = injectionPattern.getErrorText()) == null || error_text.equals(""))) {
                throw new ConfigException(error_text);
            }
            if (value == null && valueMap != null && !valueMap.containsKey(injectionPattern.getKey())) {
                throw new ConfigException("\"${" + content + "}\" appears in config file cannot be expanded");
            }
        }
        return value;
    }

    private static InjectionPattern getInjectionPattern(String contents) {
        if (contents == null || contents.trim().equals("")) {
            return null;
        }
        InjectionPattern injectionPattern = new InjectionPattern();
        contents = contents.trim();
        String[] array = contents.split(":", 2);
        array[0] = array[0].trim();
        if ("".equals(array[0])) {
            return null;
        }
        injectionPattern.setKey(array[0]);
        if (array.length == 2) {
            array[1] = array[1].trim();
            if (array[1].startsWith("?")) {
                injectionPattern.setErrorText(array[1].substring(1));
            } else if (array[1].startsWith("$")) {
                if (array[1].length() == 1) {
                    injectionPattern.setDefaultValue("\\$\\{" + array[0] + "\\}");
                } else {
                    injectionPattern.setDefaultValue("\\" + array[1]);
                }
            } else {
                injectionPattern.setDefaultValue(array[1]);
            }
        }
        return injectionPattern;
    }

    private static Object typeCast(String str) {
        if (str == null || str.equals("")) {
            return null;
        }
        for (String trueString : trueArray) {
            if (!trueString.equals(str)) continue;
            return true;
        }
        for (String falseString : falseArray) {
            if (!falseString.equals(str)) continue;
            return false;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e1) {
            try {
                return Double.parseDouble(str);
            }
            catch (Exception e2) {
                return str;
            }
        }
    }

    private static class InjectionPattern {
        private String key;
        private String defaultValue;
        private String errorText;

        private InjectionPattern() {
        }

        public String getErrorText() {
            return this.errorText;
        }

        public void setErrorText(String errorTest) {
            this.errorText = errorTest;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }
}

