/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JsonMapper {
    public static ObjectMapper objectMapper = new ObjectMapper();

    public static String toJson(Object x) {
        try {
            return objectMapper.writeValueAsString(x);
        }
        catch (JsonProcessingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static <T> T fromJson(String json, Class<T> targetType) {
        try {
            return objectMapper.readValue(json, targetType);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static <T> T fromJsonByName(String json, String targetType) {
        try {
            return (T)objectMapper.readValue(json, JsonMapper.class.getClassLoader().loadClass(targetType));
        }
        catch (IOException | ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static Map<String, Object> string2Map(String s2) {
        try {
            return (Map)objectMapper.readValue(s2, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static List<Map<String, Object>> string2List(String s2) {
        try {
            return (List)objectMapper.readValue(s2, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    static {
        objectMapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

