/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import com.networknt.consul.ConsulResponse;
import com.networknt.consul.ConsulService;
import com.networknt.consul.client.ConsulClient;
import com.networknt.httpstring.HttpStringConstants;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;

public class ConsulClientImpl
implements ConsulClient {
    private static final Logger logger = LoggerFactory.getLogger(ConsulClientImpl.class);
    private static final ConsulConfig config = (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    Http2Client client = Http2Client.getInstance();
    ClientConnection connection;
    OptionMap optionMap;
    URI uri;
    int maxReqPerConn;
    int reqCounter = 0;
    String wait = "600s";

    public ConsulClientImpl() {
        String consulUrl = config.getConsulUrl().toLowerCase();
        OptionMap optionMap = this.optionMap = consulUrl.startsWith("https") ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY;
        if (logger.isDebugEnabled()) {
            logger.debug("url = " + consulUrl);
        }
        if (config.getWait() != null && config.getWait().length() > 2) {
            this.wait = config.getWait();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("wait = " + this.wait);
        }
        try {
            this.uri = new URI(consulUrl);
        }
        catch (URISyntaxException e2) {
            logger.error("Invalid URI " + consulUrl, e2);
            throw new RuntimeException("Invalid URI " + consulUrl, e2);
        }
        this.maxReqPerConn = config.getMaxReqPerConn() > 0 ? config.getMaxReqPerConn() : 1000000;
    }

    @Override
    public void checkPass(String serviceId, String token) {
        if (logger.isDebugEnabled()) {
            logger.debug("checkPass serviceId = " + serviceId);
        }
        String path = "/v1/agent/check/pass/service:" + serviceId;
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            if (this.connection == null || !this.connection.isOpen() || this.reqCounter >= this.maxReqPerConn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("connection is closed with counter " + this.reqCounter + ", reconnecting...");
                }
                this.connection = this.client.connect(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
                this.reqCounter = 0;
            }
            ClientRequest request = new ClientRequest().setMethod(Methods.PUT).setPath(path);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            if (token != null) {
                request.getRequestHeaders().put(HttpStringConstants.CONSUL_TOKEN, token);
            }
            this.connection.sendRequest(request, this.client.createClientCallback(reference, latch));
            latch.await();
            ++this.reqCounter;
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to checkPass on Consul: " + statusCode + ":" + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                throw new Exception("Failed to checkPass on Consul: " + statusCode + ":" + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
        }
        catch (Exception e2) {
            logger.error("CheckPass request exception", e2);
        }
    }

    @Override
    public void checkFail(String serviceId, String token) {
        if (logger.isDebugEnabled()) {
            logger.debug("checkFail serviceId = " + serviceId);
        }
        String path = "/v1/agent/check/fail/service:" + serviceId;
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            if (this.connection == null || !this.connection.isOpen() || this.reqCounter >= this.maxReqPerConn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("connection is closed with counter " + this.reqCounter + ", reconnecting...");
                }
                this.connection = this.client.connect(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
                this.reqCounter = 0;
            }
            ClientRequest request = new ClientRequest().setMethod(Methods.PUT).setPath(path);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            if (token != null) {
                request.getRequestHeaders().put(HttpStringConstants.CONSUL_TOKEN, token);
            }
            this.connection.sendRequest(request, this.client.createClientCallback(reference, latch));
            latch.await();
            ++this.reqCounter;
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to checkPass on Consul: " + statusCode + ":" + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                throw new Exception("Failed to checkPass on Consul: " + statusCode + ":" + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
        }
        catch (Exception e2) {
            logger.error("CheckPass request exception", e2);
        }
    }

    @Override
    public void registerService(ConsulService service, String token) {
        String json = service.toString();
        String path = "/v1/agent/service/register";
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            if (this.connection == null || !this.connection.isOpen() || this.reqCounter >= this.maxReqPerConn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("connection is closed with counter " + this.reqCounter + ", reconnecting...");
                }
                this.connection = this.client.connect(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
                this.reqCounter = 0;
            }
            ClientRequest request = new ClientRequest().setMethod(Methods.PUT).setPath(path);
            if (token != null) {
                request.getRequestHeaders().put(HttpStringConstants.CONSUL_TOKEN, token);
            }
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
            this.connection.sendRequest(request, this.client.createClientCallback(reference, latch, json));
            latch.await();
            ++this.reqCounter;
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                throw new Exception("Failed to register on Consul: " + statusCode);
            }
        }
        catch (Exception e2) {
            logger.error("Exception:", e2);
            throw new RuntimeException(e2.getMessage());
        }
    }

    @Override
    public void unregisterService(String serviceId, String token) {
        String path = "/v1/agent/service/deregister/" + serviceId;
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            if (this.connection == null || !this.connection.isOpen() || this.reqCounter >= this.maxReqPerConn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("connection is closed with counter " + this.reqCounter + ", reconnecting...");
                }
                this.connection = this.client.connect(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
                this.reqCounter = 0;
            }
            ClientRequest request = new ClientRequest().setMethod(Methods.PUT).setPath(path);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            if (token != null) {
                request.getRequestHeaders().put(HttpStringConstants.CONSUL_TOKEN, token);
            }
            this.connection.sendRequest(request, this.client.createClientCallback(reference, latch));
            latch.await();
            ++this.reqCounter;
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                System.out.println("body = " + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                throw new Exception("Failed to unregister on Consul: " + statusCode);
            }
        }
        catch (Exception e2) {
            logger.error("Exception:", e2);
        }
    }

    @Override
    public ConsulResponse<List<ConsulService>> lookupHealthService(String serviceName, String tag, long lastConsulIndex, String token) {
        ConsulResponse<ArrayList<ConsulService>> newResponse = null;
        String path = "/v1/health/service/" + serviceName + "?passing&wait=" + this.wait + "&index=" + lastConsulIndex;
        if (tag != null) {
            path = path + "&tag=" + tag;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("path = " + path);
        }
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        try {
            if (this.connection == null || !this.connection.isOpen() || this.reqCounter >= this.maxReqPerConn) {
                if (logger.isDebugEnabled()) {
                    logger.debug("connection is closed with counter " + this.reqCounter + ", reconnecting...");
                }
                this.connection = this.client.connect(this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap).get();
                this.reqCounter = 0;
            }
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(path);
            if (token != null) {
                request.getRequestHeaders().put(HttpStringConstants.CONSUL_TOKEN, token);
            }
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            this.connection.sendRequest(request, this.client.createClientCallback(reference, latch));
            latch.await();
            ++this.reqCounter;
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                if (logger.isDebugEnabled()) {
                    logger.debug("body = " + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                }
                throw new Exception("Failed to unregister on Consul: " + statusCode);
            }
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (logger.isDebugEnabled()) {
                logger.debug("body = " + body);
            }
            List services = (List)Config.getInstance().getMapper().readValue(body, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            ArrayList<ConsulService> ConsulServcies = new ArrayList<ConsulService>(services.size());
            for (Map service : services) {
                ConsulService newService = this.convertToConsulService((Map)service.get("Service"));
                ConsulServcies.add(newService);
            }
            if (!ConsulServcies.isEmpty()) {
                newResponse = new ConsulResponse<ArrayList<ConsulService>>();
                newResponse.setValue(ConsulServcies);
                newResponse.setConsulIndex(Long.parseLong(reference.get().getResponseHeaders().getFirst("X-Consul-Index")));
                newResponse.setConsulLastContact(Long.parseLong(reference.get().getResponseHeaders().getFirst("X-Consul-Lastcontact")));
                newResponse.setConsulKnownLeader(Boolean.parseBoolean(reference.get().getResponseHeaders().getFirst("X-Consul-Knownleader")));
            }
        }
        catch (Exception e2) {
            logger.error("Exception:", e2);
        }
        return newResponse;
    }

    private ConsulService convertToConsulService(Map<String, Object> serviceMap) {
        ConsulService service = new ConsulService();
        service.setAddress((String)serviceMap.get("Address"));
        service.setId((String)serviceMap.get("ID"));
        service.setName((String)serviceMap.get("Service"));
        service.setPort((Integer)serviceMap.get("Port"));
        service.setTags((List)serviceMap.get("Tags"));
        return service;
    }
}

