/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.decrypt;

import com.networknt.utility.Decryptor;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;

public class AESDecryptor
implements Decryptor {
    private static final int ITERATIONS = 65536;
    private static final String STRING_ENCODING = "UTF-8";
    private static final int KEY_SIZE = 128;
    private static final byte[] SALT = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private SecretKeySpec secret;
    private Cipher cipher;
    private BASE64Decoder base64Decoder;

    public AESDecryptor() {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec("light".toCharArray(), SALT, 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            this.secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.base64Decoder = new BASE64Decoder();
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to initialize AESDecryptor", e2);
        }
    }

    @Override
    public String decrypt(String input) {
        if (!input.startsWith("CRYPT")) {
            throw new RuntimeException("Unable to decrypt, input string does not start with 'CRYPT'");
        }
        try {
            byte[] data = this.base64Decoder.decodeBuffer(input.substring(6, input.length()));
            int keylen = 16;
            byte[] iv = new byte[keylen];
            System.arraycopy(data, 0, iv, 0, keylen);
            this.cipher.init(2, (Key)this.secret, new IvParameterSpec(iv));
            return new String(this.cipher.doFinal(data, keylen, data.length - keylen), STRING_ENCODING);
        }
        catch (Exception e2) {
            throw new RuntimeException("Unable to decrypt.", e2);
        }
    }
}

