/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.cdc.polling;

import com.networknt.eventuate.server.common.CdcKafkaPublisher;
import com.networknt.eventuate.server.common.PublishingStrategy;
import com.networknt.eventuate.server.common.exception.EventuateLocalPublishingException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingCdcKafkaPublisher<EVENT>
extends CdcKafkaPublisher<EVENT> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public PollingCdcKafkaPublisher(String kafkaBootstrapServers, PublishingStrategy<EVENT> publishingStrategy) {
        super(publishingStrategy);
    }

    @Override
    public void handleEvent(EVENT event) throws EventuateLocalPublishingException {
        this.logger.trace("Got record " + event.toString());
        String aggregateTopic = this.publishingStrategy.topicFor(event);
        String json = this.publishingStrategy.toJson(event);
        Exception lastException = null;
        for (int i2 = 0; i2 < 5; ++i2) {
            try {
                this.producer.send(aggregateTopic, this.publishingStrategy.partitionKeyFor(event), json).get(10L, TimeUnit.SECONDS);
                return;
            }
            catch (Exception e2) {
                this.logger.warn("error publishing to " + aggregateTopic, e2);
                lastException = e2;
                try {
                    Thread.sleep((int)Math.pow(2.0, i2) * 1000);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
        }
        throw new EventuateLocalPublishingException("error publishing to " + aggregateTopic, lastException);
    }
}

