/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common;

import com.networknt.eventuate.common.Aggregate;
import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.MissingApplyEventMethodStrategy;
import com.networknt.eventuate.common.MissingApplyMethodException;
import java.util.List;

public class Aggregates {
    public static <T extends Aggregate<T>> T applyEventsToMutableAggregate(T aggregate, List<Event> events, MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        for (Event event : events) {
            try {
                aggregate = aggregate.applyEvent(event);
            }
            catch (MissingApplyMethodException e2) {
                missingApplyEventMethodStrategy.handle(aggregate, e2);
            }
        }
        return aggregate;
    }

    public static <T extends Aggregate<T>> T recreateAggregate(Class<T> clasz, List<Event> events, MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        return Aggregates.applyEventsToMutableAggregate(Aggregates.newAggregate(clasz), events, missingApplyEventMethodStrategy);
    }

    private static <T extends Aggregate<T>> T newAggregate(Class<T> clasz) {
        try {
            return (T)((Aggregate)clasz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e2) {
            throw new RuntimeException(e2);
        }
    }
}

