/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common;

public class Int128 {
    private long hi;
    private long lo;

    public Int128(long hi, long lo) {
        this.hi = hi;
        this.lo = lo;
    }

    public String asString() {
        return String.format("%016x-%016x", this.hi, this.lo);
    }

    public String toString() {
        return "Int128{" + this.asString() + '}';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Int128 int128 = (Int128)o2;
        return this.hi == int128.hi && this.lo == int128.lo;
    }

    public int hashCode() {
        int result = (int)(this.hi ^ this.hi >>> 32);
        result = 31 * result + (int)(this.lo ^ this.lo >>> 32);
        return result;
    }

    public static Int128 fromString(String str) {
        String[] s2 = str.split("-");
        if (s2.length != 2) {
            throw new IllegalArgumentException("Should have length of 2: " + str);
        }
        return new Int128(Long.parseUnsignedLong(s2[0], 16), Long.parseUnsignedLong(s2[1], 16));
    }

    public int compareTo(Int128 other) {
        int x = Long.compare(this.hi, other.hi);
        return x == 0 ? Long.compare(this.lo, other.lo) : x;
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }
}

