/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common;

import com.networknt.eventuate.common.Aggregate;
import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.EventWithMetadata;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.MissingApplyEventMethodStrategy;
import com.networknt.eventuate.common.Snapshot;
import com.networknt.eventuate.common.SnapshotManager;
import com.networknt.eventuate.common.SnapshotStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SnapshotManagerImpl
implements SnapshotManager {
    private Map<Class<?>, SnapshotStrategy> strategies = new HashMap();

    public void addStrategy(SnapshotStrategy snapshotStrategy) {
        this.strategies.put(snapshotStrategy.getAggregateClass(), snapshotStrategy);
    }

    @Override
    public Optional<Snapshot> possiblySnapshot(Aggregate aggregate, Optional<Int128> snapshotVersion, List<EventWithMetadata> oldEvents, List<Event> newEvents) {
        SnapshotStrategy strategy = this.strategies.get(aggregate.getClass());
        if (strategy == null) {
            return Optional.empty();
        }
        return strategy.possiblySnapshot(aggregate, snapshotVersion, oldEvents, newEvents);
    }

    @Override
    public Aggregate recreateFromSnapshot(Class<?> clasz, Snapshot snapshot, MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        SnapshotStrategy strategy = this.strategies.get(clasz);
        return strategy.recreateAggregate(clasz, snapshot, missingApplyEventMethodStrategy);
    }
}

