/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common.impl;

import com.networknt.eventuate.common.DispatchedEvent;
import com.networknt.eventuate.common.EndOfCurrentEventsReachedEvent;
import com.networknt.eventuate.common.Event;
import com.networknt.eventuate.common.impl.JSonMapper;
import com.networknt.eventuate.common.impl.SerializedEvent;
import com.networknt.eventuate.common.impl.SerializedEventDeserializer;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSerializedEventDeserializer
implements SerializedEventDeserializer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Optional<DispatchedEvent<Event>> toDispatchedEvent(SerializedEvent se) {
        String eventType = se.getEventType();
        Class<Event> eventClass = this.toEventClass(eventType);
        Event event = JSonMapper.fromJson(se.getEventData(), eventClass);
        return Optional.of(new DispatchedEvent<Event>(se.getEntityId(), se.getId(), event, se.getSwimLane(), se.getOffset(), se.getEventContext(), se.getMetadata() == null ? Optional.empty() : se.getMetadata().map(md -> JSonMapper.fromJson(md, Map.class))));
    }

    private Class<Event> toEventClass(String eventType) {
        if ("com.networknt.eventuate.common.EndOfCurrentEventsReachedEvent".equals(eventType)) {
            eventType = EndOfCurrentEventsReachedEvent.class.getName();
        }
        try {
            return Class.forName(eventType);
        }
        catch (ClassNotFoundException e2) {
            this.logger.error("Event class not found", e2);
            throw new RuntimeException(e2);
        }
    }
}

