/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.common.impl.adapters;

import com.networknt.eventuate.common.Aggregate;
import com.networknt.eventuate.common.CompletableFutureUtil;
import com.networknt.eventuate.common.EntityIdAndType;
import com.networknt.eventuate.common.Int128;
import com.networknt.eventuate.common.impl.AggregateCrud;
import com.networknt.eventuate.common.impl.AggregateCrudFindOptions;
import com.networknt.eventuate.common.impl.AggregateCrudSaveOptions;
import com.networknt.eventuate.common.impl.AggregateCrudUpdateOptions;
import com.networknt.eventuate.common.impl.EntityIdVersionAndEventIds;
import com.networknt.eventuate.common.impl.EventTypeAndData;
import com.networknt.eventuate.common.impl.LoadedEvents;
import com.networknt.eventuate.common.impl.adapters.AsyncToSyncTimeoutOptions;
import java.util.List;
import java.util.Optional;

public class AsyncToSyncAggregateCrudAdapter
implements com.networknt.eventuate.common.impl.sync.AggregateCrud {
    private AggregateCrud target;
    private AsyncToSyncTimeoutOptions timeoutOptions = new AsyncToSyncTimeoutOptions();

    public AsyncToSyncAggregateCrudAdapter(AggregateCrud target) {
        this.target = target;
    }

    @Override
    public EntityIdVersionAndEventIds save(String aggregateType, List<EventTypeAndData> events, Optional<AggregateCrudSaveOptions> options) {
        try {
            return this.target.save(aggregateType, events, options).get(this.timeoutOptions.getTimeout(), this.timeoutOptions.getTimeUnit());
        }
        catch (Throwable e2) {
            Throwable unwrapped = CompletableFutureUtil.unwrap(e2);
            if (unwrapped instanceof RuntimeException) {
                throw (RuntimeException)unwrapped;
            }
            throw new RuntimeException(unwrapped);
        }
    }

    @Override
    public <T extends Aggregate<T>> LoadedEvents find(String aggregateType, String entityId, Optional<AggregateCrudFindOptions> findOptions) {
        try {
            return this.target.find(aggregateType, entityId, findOptions).get(this.timeoutOptions.getTimeout(), this.timeoutOptions.getTimeUnit());
        }
        catch (Throwable e2) {
            Throwable unwrapped = CompletableFutureUtil.unwrap(e2);
            if (unwrapped instanceof RuntimeException) {
                throw (RuntimeException)unwrapped;
            }
            throw new RuntimeException(unwrapped);
        }
    }

    @Override
    public EntityIdVersionAndEventIds update(EntityIdAndType entityIdAndType, Int128 entityVersion, List<EventTypeAndData> events, Optional<AggregateCrudUpdateOptions> updateOptions) {
        try {
            return this.target.update(entityIdAndType, entityVersion, events, updateOptions).get(this.timeoutOptions.getTimeout(), this.timeoutOptions.getTimeUnit());
        }
        catch (Throwable e2) {
            Throwable unwrapped = CompletableFutureUtil.unwrap(e2);
            if (unwrapped instanceof RuntimeException) {
                throw (RuntimeException)unwrapped;
            }
            throw new RuntimeException(unwrapped);
        }
    }

    public void setTimeoutOptions(AsyncToSyncTimeoutOptions timeoutOptions) {
        this.timeoutOptions = timeoutOptions;
    }
}

