/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.jdbc;

import com.networknt.utility.StringUtils;

public class EventuateSchema {
    public static final String DEFAULT_SCHEMA = "eventuate";
    public static final String EMPTY_SCHEMA = "none";
    private final String eventuateDatabaseSchema;

    public EventuateSchema() {
        this.eventuateDatabaseSchema = DEFAULT_SCHEMA;
    }

    public EventuateSchema(String eventuateDatabaseSchema) {
        this.eventuateDatabaseSchema = StringUtils.isNullOrEmpty(eventuateDatabaseSchema) ? DEFAULT_SCHEMA : eventuateDatabaseSchema;
    }

    public String getEventuateDatabaseSchema() {
        return this.eventuateDatabaseSchema;
    }

    public boolean isEmpty() {
        return EMPTY_SCHEMA.equals(this.eventuateDatabaseSchema);
    }

    public boolean isDefault() {
        return DEFAULT_SCHEMA.equals(this.eventuateDatabaseSchema);
    }

    public String qualifyTable(String table) {
        if (this.isEmpty()) {
            return table;
        }
        String schema = this.isDefault() ? DEFAULT_SCHEMA : this.eventuateDatabaseSchema;
        return String.format("%s.%s", schema, table);
    }
}

