/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.kafka.consumer;

import com.networknt.eventuate.kafka.consumer.TopicPartitionOffsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class OffsetTracker {
    private Map<TopicPartition, TopicPartitionOffsets> state = new HashMap<TopicPartition, TopicPartitionOffsets>();

    public String toString() {
        return "OffsetTracker{state=" + this.state + '}';
    }

    TopicPartitionOffsets fetch(TopicPartition topicPartition) {
        TopicPartitionOffsets tpo = this.state.get(topicPartition);
        if (tpo == null) {
            tpo = new TopicPartitionOffsets();
            this.state.put(topicPartition, tpo);
        }
        return tpo;
    }

    void noteUnprocessed(TopicPartition topicPartition, long offset) {
        this.fetch(topicPartition).noteUnprocessed(offset);
    }

    void noteProcessed(TopicPartition topicPartition, long offset) {
        this.fetch(topicPartition).noteProcessed(offset);
    }

    public Map<TopicPartition, OffsetAndMetadata> offsetsToCommit() {
        HashMap<TopicPartition, OffsetAndMetadata> result = new HashMap<TopicPartition, OffsetAndMetadata>();
        this.state.forEach((tp, tpo) -> tpo.offsetToCommit().ifPresent(offset -> result.put((TopicPartition)tp, new OffsetAndMetadata(offset + 1L, ""))));
        return result;
    }

    public void noteOffsetsCommitted(Map<TopicPartition, OffsetAndMetadata> offsetsToCommit) {
        offsetsToCommit.forEach((tp, om) -> this.fetch((TopicPartition)tp).noteOffsetCommitted(om.offset()));
    }

    public Map<TopicPartition, Set<Long>> getPending() {
        HashMap<TopicPartition, Set<Long>> result = new HashMap<TopicPartition, Set<Long>>();
        this.state.forEach((tp, tpo) -> {
            Set<Long> pending = tpo.getPending();
            if (!pending.isEmpty()) {
                result.put((TopicPartition)tp, pending);
            }
        });
        return result;
    }
}

