/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.eventuate.kafka.producer;

import com.networknt.config.Config;
import com.networknt.eventuate.kafka.KafkaConfig;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class EventuateKafkaProducer {
    private Producer<String, String> producer;
    private Properties producerProps = new Properties();
    static final KafkaConfig config = (KafkaConfig)Config.getInstance().getJsonObjectConfig("kafka", KafkaConfig.class);

    public EventuateKafkaProducer() {
        this.producerProps.put("bootstrap.servers", config.getBootstrapServers());
        this.producerProps.put("acks", config.getAcks());
        this.producerProps.put("retries", (Object)config.getRetries());
        this.producerProps.put("batch.size", (Object)config.getBatchSize());
        this.producerProps.put("linger.ms", (Object)config.getLingerms());
        this.producerProps.put("buffer.memory", (Object)config.getBufferMemory());
        this.producerProps.put("key.serializer", config.getKeySerializer());
        this.producerProps.put("value.serializer", config.getValueSerializer());
        this.producer = new KafkaProducer<String, String>(this.producerProps);
    }

    public void setProducer(Producer<String, String> producer) {
        this.producer = producer;
    }

    public CompletableFuture<?> send(String topic, String key, String body) {
        CompletableFuture result = new CompletableFuture();
        this.producer.send(new ProducerRecord<String, String>(topic, key, body), (metadata, exception) -> {
            if (exception == null) {
                result.complete(metadata);
            } else {
                result.completeExceptionally(exception);
            }
        });
        return result;
    }

    public void close() {
        this.producer.close(1L, TimeUnit.SECONDS);
    }
}

