/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.common.DecryptUtil;
import com.networknt.config.Config;
import com.networknt.security.JwtConfig;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Map;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtIssuer {
    private static final Logger logger = LoggerFactory.getLogger(JwtIssuer.class);
    public static final String JWT_CONFIG = "jwt";
    public static final String SECRET_CONFIG = "secret";
    public static final String JWT_PRIVATE_KEY_PASSWORD = "jwtPrivateKeyPassword";
    private static JwtConfig jwtConfig = (JwtConfig)Config.getInstance().getJsonObjectConfig("jwt", JwtConfig.class);
    private static Map<String, Object> secretConfig = DecryptUtil.decryptMap(Config.getInstance().getJsonMapConfig("secret"));

    public static String getJwt(JwtClaims claims) throws JoseException {
        RSAPrivateKey privateKey = (RSAPrivateKey)JwtIssuer.getPrivateKey(jwtConfig.getKey().getFilename(), (String)secretConfig.get(JWT_PRIVATE_KEY_PASSWORD), jwtConfig.getKey().getKeyName());
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        jws.setKey(privateKey);
        String provider_id = "";
        if (jwtConfig.getProviderId() != null) {
            provider_id = jwtConfig.getProviderId();
            if (provider_id.length() == 1) {
                provider_id = "0" + provider_id;
            } else if (provider_id.length() > 2) {
                logger.error("provider_id defined in the security.yml file is invalid; the length should be 2");
                provider_id = provider_id.substring(0, 2);
            }
        }
        jws.setKeyIdHeaderValue(provider_id + jwtConfig.getKey().getKid());
        jws.setAlgorithmHeaderValue("RS256");
        String jwt = jws.getCompactSerialization();
        return jwt;
    }

    public static JwtClaims getDefaultJwtClaims() {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(jwtConfig.getIssuer());
        claims.setAudience(jwtConfig.getAudience());
        claims.setExpirationTimeMinutesInTheFuture(jwtConfig.getExpiredInMinutes());
        claims.setGeneratedJwtId();
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast(2.0f);
        claims.setClaim("version", jwtConfig.getVersion());
        return claims;
    }

    public static JwtClaims getJwtClaimsWithExpiresIn(int expiresIn) {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(jwtConfig.getIssuer());
        claims.setAudience(jwtConfig.getAudience());
        claims.setExpirationTimeMinutesInTheFuture(expiresIn / 60);
        claims.setGeneratedJwtId();
        claims.setIssuedAtToNow();
        claims.setNotBeforeMinutesInThePast(2.0f);
        claims.setClaim("version", jwtConfig.getVersion());
        return claims;
    }

    private static PrivateKey getPrivateKey(String filename, String password, String key) {
        if (logger.isDebugEnabled()) {
            logger.debug("filename = " + filename + " key = " + key);
        }
        PrivateKey privateKey = null;
        try {
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(Config.getInstance().getInputStreamFromFile(filename), password.toCharArray());
            privateKey = (PrivateKey)keystore.getKey(key, password.toCharArray());
        }
        catch (Exception e2) {
            logger.error("Exception:", e2);
        }
        if (privateKey == null) {
            logger.error("Failed to retrieve private key from keystore");
        }
        return privateKey;
    }
}

