/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;

public class DateUtil {
    static final DateTimeFormatter ALTERNATE_ISO_8601_DATE_FORMAT = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").toFormatter().withZone(ZoneOffset.UTC);

    public static String formatIso8601Date(Instant date) {
        return DateTimeFormatter.ISO_INSTANT.format(date);
    }

    public static Instant parseIso8601Date(String dateString) {
        if (dateString.endsWith("+0000")) {
            dateString = dateString.substring(0, dateString.length() - 5).concat("Z");
        }
        try {
            return DateUtil.parseInstant(dateString, DateTimeFormatter.ISO_INSTANT);
        }
        catch (DateTimeParseException e2) {
            return DateUtil.parseInstant(dateString, ALTERNATE_ISO_8601_DATE_FORMAT);
        }
    }

    private static Instant parseInstant(String dateString, DateTimeFormatter formatter) {
        return formatter.withZone(ZoneOffset.UTC).parse((CharSequence)dateString, Instant::from);
    }
}

