/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.utility;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);
    public static final String LOCALHOST = "127.0.0.1";
    public static final String ANYHOST = "0.0.0.0";
    private static volatile InetAddress LOCAL_ADDRESS = null;
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^\\d{1,3}(\\.\\d{1,3}){3}\\:\\d{1,5}$");
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");

    public static boolean isInvalidLocalHost(String host) {
        return host == null || host.length() == 0 || host.equalsIgnoreCase("localhost") || host.equals(ANYHOST) || LOCAL_IP_PATTERN.matcher(host).matches();
    }

    public static boolean isValidLocalHost(String host) {
        return !NetUtils.isInvalidLocalHost(host);
    }

    public static InetAddress getLocalAddress() {
        return NetUtils.getLocalAddress(null);
    }

    public static InetAddress getLocalAddress(Map<String, Integer> destHostPorts) {
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        InetAddress localAddress = NetUtils.getLocalAddressByHostname();
        if (!NetUtils.isValidAddress(localAddress)) {
            localAddress = NetUtils.getLocalAddressBySocket(destHostPorts);
        }
        if (!NetUtils.isValidAddress(localAddress)) {
            localAddress = NetUtils.getLocalAddressByNetworkInterface();
        }
        if (NetUtils.isValidAddress(localAddress)) {
            LOCAL_ADDRESS = localAddress;
        }
        return localAddress;
    }

    private static InetAddress getLocalAddressByHostname() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Throwable e2) {
            logger.error("Failed to retriving local address by hostname:" + e2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InetAddress getLocalAddressBySocket(Map<String, Integer> destHostPorts) {
        if (destHostPorts == null) return null;
        if (destHostPorts.size() == 0) {
            return null;
        }
        Iterator<Map.Entry<String, Integer>> iterator = destHostPorts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> entry = iterator.next();
            String host = entry.getKey();
            int port = entry.getValue();
            try {
                Socket socket = new Socket();
                try {
                    InetSocketAddress addr = new InetSocketAddress(host, port);
                    socket.connect(addr, 1000);
                    InetAddress inetAddress = socket.getLocalAddress();
                    return inetAddress;
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Exception e2) {
                logger.error(String.format("Failed to retriving local address by connecting to dest host:port(%s:%s) false, e=%s", host, port, e2));
            }
        }
        return null;
    }

    private static InetAddress getLocalAddressByNetworkInterface() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    try {
                        NetworkInterface network = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = network.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            try {
                                InetAddress address = addresses.nextElement();
                                if (!NetUtils.isValidAddress(address)) continue;
                                return address;
                            }
                            catch (Throwable e2) {
                                logger.error("Failed to retriving ip address, " + e2.getMessage(), e2);
                            }
                        }
                    }
                    catch (Throwable e3) {
                        logger.error("Failed to retriving ip address, " + e3.getMessage(), e3);
                    }
                }
            }
        }
        catch (Throwable e4) {
            logger.error("Failed to retriving ip address, " + e4.getMessage(), e4);
        }
        return null;
    }

    public static boolean isValidAddress(String address) {
        return ADDRESS_PATTERN.matcher(address).matches();
    }

    public static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    public static String getHostName(SocketAddress socketAddress) {
        InetAddress addr;
        if (socketAddress == null) {
            return null;
        }
        if (socketAddress instanceof InetSocketAddress && (addr = ((InetSocketAddress)socketAddress).getAddress()) != null) {
            return addr.getHostAddress();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalAddressByDatagram() {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            String string = socket.getLocalAddress().getHostAddress();
            return string;
        }
        catch (Exception e2) {
            logger.error("Failed to retrieving ip address.", e2);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailablePort() {
        int i2 = 0;
        while (i2 < 50) {
            try (ServerSocket serverSocket = new ServerSocket(0);){
                int port = serverSocket.getLocalPort();
                if (port != 0) {
                    int n2 = port;
                    return n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i2;
        }
        throw new RuntimeException("Could not find a free permitted port on the machine.");
    }

    public static String hostAndPortToUrlString(String host, int port) throws UnknownHostException {
        return NetUtils.ipAddressAndPortToUrlString(InetAddress.getByName(host), port);
    }

    public static String ipAddressAndPortToUrlString(InetAddress address, int port) {
        return NetUtils.ipAddressToUrlString(address) + ':' + port;
    }

    public static String ipAddressToUrlString(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        if (address instanceof Inet4Address) {
            return address.getHostAddress();
        }
        if (address instanceof Inet6Address) {
            return NetUtils.getIPv6UrlRepresentation((Inet6Address)address);
        }
        throw new IllegalArgumentException("Unrecognized type of InetAddress: " + address);
    }

    private static String getIPv6UrlRepresentation(Inet6Address address) {
        return NetUtils.getIPv6UrlRepresentation(address.getAddress());
    }

    private static String getIPv6UrlRepresentation(byte[] addressBytes) {
        int[] hextets = new int[8];
        for (int i2 = 0; i2 < hextets.length; ++i2) {
            hextets[i2] = (addressBytes[2 * i2] & 0xFF) << 8 | addressBytes[2 * i2 + 1] & 0xFF;
        }
        int bestRunStart = -1;
        int bestRunLength = -1;
        int runStart = -1;
        for (int i3 = 0; i3 < hextets.length + 1; ++i3) {
            if (i3 < hextets.length && hextets[i3] == 0) {
                if (runStart >= 0) continue;
                runStart = i3;
                continue;
            }
            if (runStart < 0) continue;
            int runLength = i3 - runStart;
            if (runLength > bestRunLength) {
                bestRunStart = runStart;
                bestRunLength = runLength;
            }
            runStart = -1;
        }
        if (bestRunLength >= 2) {
            Arrays.fill(hextets, bestRunStart, bestRunStart + bestRunLength, -1);
        }
        StringBuilder buf = new StringBuilder(40);
        buf.append('[');
        boolean lastWasNumber = false;
        for (int i4 = 0; i4 < hextets.length; ++i4) {
            boolean thisIsNumber;
            boolean bl = thisIsNumber = hextets[i4] >= 0;
            if (thisIsNumber) {
                if (lastWasNumber) {
                    buf.append(':');
                }
                buf.append(Integer.toHexString(hextets[i4]));
            } else if (i4 == 0 || lastWasNumber) {
                buf.append("::");
            }
            lastWasNumber = thisIsNumber;
        }
        buf.append(']');
        return buf.toString();
    }
}

