/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowMessages;
import io.undertow.util.HeaderMap;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FormData
implements Iterable<String> {
    private final Map<String, Deque<FormValue>> values = new LinkedHashMap<String, Deque<FormValue>>();
    private final int maxValues;
    private int valueCount = 0;

    public FormData(int maxValues) {
        this.maxValues = maxValues;
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.keySet().iterator();
    }

    public FormValue getFirst(String name) {
        Deque<FormValue> deque = this.values.get(name);
        return deque == null ? null : deque.peekFirst();
    }

    public FormValue getLast(String name) {
        Deque<FormValue> deque = this.values.get(name);
        return deque == null ? null : deque.peekLast();
    }

    public Deque<FormValue> get(String name) {
        return this.values.get(name);
    }

    public void add(String name, byte[] value, String fileName, HeaderMap headers) {
        Deque<FormValue> values = this.values.get(name);
        if (values == null) {
            values = new ArrayDeque<FormValue>(1);
            this.values.put(name, values);
        }
        values.add(new FormValueImpl(value, fileName, headers));
        if (++this.valueCount > this.maxValues) {
            throw new RuntimeException(UndertowMessages.MESSAGES.tooManyParameters(this.maxValues));
        }
    }

    public void add(String name, String value) {
        this.add(name, value, null);
    }

    public void add(String name, String value, HeaderMap headers) {
        Deque<FormValue> values = this.values.get(name);
        if (values == null) {
            values = new ArrayDeque<FormValue>(1);
            this.values.put(name, values);
        }
        values.add(new FormValueImpl(value, headers));
        if (++this.valueCount > this.maxValues) {
            throw new RuntimeException(UndertowMessages.MESSAGES.tooManyParameters(this.maxValues));
        }
    }

    public void add(String name, Path value, String fileName, HeaderMap headers) {
        Deque<FormValue> values = this.values.get(name);
        if (values == null) {
            values = new ArrayDeque<FormValue>(1);
            this.values.put(name, values);
        }
        values.add(new FormValueImpl(value, fileName, headers));
        if (values.size() > this.maxValues) {
            throw new RuntimeException(UndertowMessages.MESSAGES.tooManyParameters(this.maxValues));
        }
        if (++this.valueCount > this.maxValues) {
            throw new RuntimeException(UndertowMessages.MESSAGES.tooManyParameters(this.maxValues));
        }
    }

    public void put(String name, String value, HeaderMap headers) {
        ArrayDeque<FormValueImpl> values = new ArrayDeque<FormValueImpl>(1);
        Deque old = this.values.put(name, values);
        if (old != null) {
            this.valueCount -= old.size();
        }
        values.add(new FormValueImpl(value, headers));
        if (++this.valueCount > this.maxValues) {
            throw new RuntimeException(UndertowMessages.MESSAGES.tooManyParameters(this.maxValues));
        }
    }

    public Deque<FormValue> remove(String name) {
        Deque<FormValue> old = this.values.remove(name);
        if (old != null) {
            this.valueCount -= old.size();
        }
        return old;
    }

    public boolean contains(String name) {
        Deque<FormValue> value = this.values.get(name);
        return value != null && !value.isEmpty();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        FormData strings = (FormData)o2;
        return !(this.values != null ? !this.values.equals(strings.values) : strings.values != null);
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }

    public String toString() {
        return "FormData{values=" + this.values + '}';
    }

    static class FormValueImpl
    implements FormValue {
        private final String value;
        private final String fileName;
        private final HeaderMap headers;
        private final FileItem fileItem;

        FormValueImpl(String value, HeaderMap headers) {
            this.value = value;
            this.headers = headers;
            this.fileName = null;
            this.fileItem = null;
        }

        FormValueImpl(Path file, String fileName, HeaderMap headers) {
            this.fileItem = new FileItem(file);
            this.headers = headers;
            this.fileName = fileName;
            this.value = null;
        }

        FormValueImpl(byte[] data, String fileName, HeaderMap headers) {
            this.fileItem = new FileItem(data);
            this.fileName = fileName;
            this.headers = headers;
            this.value = null;
        }

        @Override
        public String getValue() {
            if (this.value == null) {
                throw UndertowMessages.MESSAGES.formValueIsAFile();
            }
            return this.value;
        }

        @Override
        public boolean isFile() {
            return this.fileItem != null && !this.fileItem.isInMemory();
        }

        @Override
        public Path getPath() {
            if (this.fileItem == null) {
                throw UndertowMessages.MESSAGES.formValueIsAString();
            }
            if (this.fileItem.isInMemory()) {
                throw UndertowMessages.MESSAGES.formValueIsInMemoryFile();
            }
            return this.fileItem.getFile();
        }

        @Override
        public File getFile() {
            return this.getPath().toFile();
        }

        @Override
        public FileItem getFileItem() {
            if (this.fileItem == null) {
                throw UndertowMessages.MESSAGES.formValueIsAString();
            }
            return this.fileItem;
        }

        @Override
        public boolean isFileItem() {
            return this.fileItem != null;
        }

        @Override
        public HeaderMap getHeaders() {
            return this.headers;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }
    }

    public static class FileItem {
        private final Path file;
        private final byte[] content;

        public FileItem(Path file) {
            this.file = file;
            this.content = null;
        }

        public FileItem(byte[] content) {
            this.file = null;
            this.content = content;
        }

        public boolean isInMemory() {
            return this.file == null;
        }

        public Path getFile() {
            return this.file;
        }

        public long getFileSize() throws IOException {
            if (this.isInMemory()) {
                return this.content.length;
            }
            return Files.size(this.file);
        }

        public InputStream getInputStream() throws IOException {
            if (this.file != null) {
                return new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]));
            }
            return new ByteArrayInputStream(this.content);
        }

        public void delete() throws IOException {
            if (this.file != null) {
                try {
                    Files.delete(this.file);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
        }

        public void write(Path target) throws IOException {
            if (this.file != null) {
                try {
                    Files.move(this.file, target, new CopyOption[0]);
                }
                catch (IOException e2) {
                    Files.copy(this.getInputStream(), target, new CopyOption[0]);
                }
            } else {
                Files.copy(this.getInputStream(), target, new CopyOption[0]);
            }
        }
    }

    public static interface FormValue {
        public String getValue();

        @Deprecated
        public boolean isFile();

        @Deprecated
        public Path getPath();

        @Deprecated
        public File getFile();

        public FileItem getFileItem();

        public boolean isFileItem();

        public String getFileName();

        public HeaderMap getHeaders();
    }
}

