/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.Headers;
import io.undertow.util.SameThreadExecutor;
import io.undertow.util.URLUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;

public class FormEncodedDataDefinition
implements FormParserFactory.ParserDefinition<FormEncodedDataDefinition> {
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private String defaultEncoding = "ISO-8859-1";
    private boolean forceCreation = false;

    @Override
    public FormDataParser create(HttpServerExchange exchange) {
        String mimeType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (this.forceCreation || mimeType != null && mimeType.startsWith(APPLICATION_X_WWW_FORM_URLENCODED)) {
            String cs;
            String charset = this.defaultEncoding;
            String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
            if (contentType != null && (cs = Headers.extractQuotedValueFromHeader(contentType, "charset")) != null) {
                charset = cs;
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Created form encoded parser for %s", (Object)exchange);
            return new FormEncodedDataParser(charset, exchange);
        }
        return null;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean isForceCreation() {
        return this.forceCreation;
    }

    public FormEncodedDataDefinition setForceCreation(boolean forceCreation) {
        this.forceCreation = forceCreation;
        return this;
    }

    @Override
    public FormEncodedDataDefinition setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    private static final class FormEncodedDataParser
    implements ChannelListener<StreamSourceChannel>,
    FormDataParser {
        private final HttpServerExchange exchange;
        private final FormData data;
        private final StringBuilder builder = new StringBuilder();
        private String name = null;
        private String charset;
        private HttpHandler handler;
        private int state = 0;

        private FormEncodedDataParser(String charset, HttpServerExchange exchange) {
            this.exchange = exchange;
            this.charset = charset;
            this.data = new FormData(exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_PARAMETERS, 1000));
        }

        @Override
        public void handleEvent(StreamSourceChannel channel) {
            try {
                this.doParse(channel);
                if (this.state == 4) {
                    this.exchange.dispatch(SameThreadExecutor.INSTANCE, this.handler);
                }
            }
            catch (IOException e2) {
                IoUtils.safeClose((Closeable)channel);
                UndertowLogger.REQUEST_IO_LOGGER.ioExceptionReadingFromChannel(e2);
                this.exchange.endExchange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doParse(StreamSourceChannel channel) throws IOException {
            int c2 = 0;
            try (PooledByteBuffer pooled = this.exchange.getConnection().getByteBufferPool().allocate();){
                ByteBuffer buffer = pooled.getBuffer();
                do {
                    buffer.clear();
                    c2 = channel.read(buffer);
                    if (c2 <= 0) continue;
                    buffer.flip();
                    while (buffer.hasRemaining()) {
                        byte n2 = buffer.get();
                        switch (this.state) {
                            case 0: {
                                if (n2 == 61) {
                                    this.name = this.builder.toString();
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                if (n2 == 38) {
                                    this.data.add(this.builder.toString(), "");
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                if (n2 == 37 || n2 == 43) {
                                    this.state = 1;
                                    this.builder.append((char)n2);
                                    break;
                                }
                                this.builder.append((char)n2);
                                break;
                            }
                            case 1: {
                                if (n2 == 61) {
                                    this.name = URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder());
                                    this.builder.setLength(0);
                                    this.state = 2;
                                    break;
                                }
                                if (n2 == 38) {
                                    this.data.add(URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder()), "");
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                this.builder.append((char)n2);
                                break;
                            }
                            case 2: {
                                if (n2 == 38) {
                                    this.data.add(this.name, this.builder.toString());
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                if (n2 == 37 || n2 == 43) {
                                    this.state = 3;
                                    this.builder.append((char)n2);
                                    break;
                                }
                                this.builder.append((char)n2);
                                break;
                            }
                            case 3: {
                                if (n2 == 38) {
                                    this.data.add(this.name, URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder()));
                                    this.builder.setLength(0);
                                    this.state = 0;
                                    break;
                                }
                                this.builder.append((char)n2);
                            }
                        }
                    }
                } while (c2 > 0);
                if (c2 == -1) {
                    if (this.state == 2) {
                        this.data.add(this.name, this.builder.toString());
                    } else if (this.state == 3) {
                        this.data.add(this.name, URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder()));
                    } else if (this.builder.length() > 0) {
                        if (this.state == 1) {
                            this.data.add(URLUtils.decode(this.builder.toString(), this.charset, true, new StringBuilder()), "");
                        } else {
                            this.data.add(this.builder.toString(), "");
                        }
                    }
                    this.state = 4;
                    this.exchange.putAttachment(FORM_DATA, this.data);
                }
            }
        }

        @Override
        public void parse(HttpHandler handler) throws Exception {
            if (this.exchange.getAttachment(FORM_DATA) != null) {
                handler.handleRequest(this.exchange);
                return;
            }
            this.handler = handler;
            StreamSourceChannel channel = this.exchange.getRequestChannel();
            if (channel == null) {
                throw new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided());
            }
            this.doParse(channel);
            if (this.state != 4) {
                channel.getReadSetter().set(this);
                channel.resumeReads();
            } else {
                this.exchange.dispatch(SameThreadExecutor.INSTANCE, handler);
            }
        }

        @Override
        public FormData parseBlocking() throws IOException {
            FormData existing = (FormData)this.exchange.getAttachment(FORM_DATA);
            if (existing != null) {
                return existing;
            }
            StreamSourceChannel channel = this.exchange.getRequestChannel();
            if (channel == null) {
                throw new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided());
            }
            while (this.state != 4) {
                this.doParse(channel);
                if (this.state == 4) continue;
                channel.awaitReadable();
            }
            return this.data;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.charset = encoding;
        }
    }
}

