/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.ajp;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.ajp.AjpServerResponseConduit;
import io.undertow.util.ImmediatePooledByteBuffer;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.StreamSourceConduit;

public class AjpServerRequestConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private static final ByteBuffer READ_BODY_CHUNK;
    private static final int HEADER_LENGTH = 6;
    private static final long STATE_READING = Long.MIN_VALUE;
    private static final long STATE_SEND_REQUIRED = 0x4000000000000000L;
    private static final long STATE_FINISHED = 0x2000000000000000L;
    private static final long STATE_MASK;
    private final HttpServerExchange exchange;
    private final AjpServerResponseConduit ajpResponseConduit;
    private final ByteBuffer headerBuffer = ByteBuffer.allocateDirect(6);
    private final ConduitListener<? super AjpServerRequestConduit> finishListener;
    private long remaining;
    private long state;
    private long totalRead;

    public AjpServerRequestConduit(StreamSourceConduit delegate, HttpServerExchange exchange, AjpServerResponseConduit ajpResponseConduit, Long size, ConduitListener<? super AjpServerRequestConduit> finishListener) {
        super(delegate);
        this.exchange = exchange;
        this.ajpResponseConduit = ajpResponseConduit;
        this.finishListener = finishListener;
        if (size == null) {
            this.state = 0x4000000000000000L;
            this.remaining = -1L;
        } else if (size == 0L) {
            this.state = 0x2000000000000000L;
            this.remaining = 0L;
        } else {
            this.state = Long.MIN_VALUE;
            this.remaining = size;
        }
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        try {
            return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
        }
        catch (IOException | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        try {
            return IoUtils.transfer(new ConduitReadableByteChannel(this), count, throughBuffer, target);
        }
        catch (IOException | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
    }

    @Override
    public void terminateReads() throws IOException {
        if (this.exchange.isPersistent() && Bits.anyAreSet(this.state, 0x2000000000000000L)) {
            return;
        }
        super.terminateReads();
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        try {
            long total = 0L;
            for (int i2 = offset; i2 < length; ++i2) {
                while (dsts[i2].hasRemaining()) {
                    int r2 = this.read(dsts[i2]);
                    if (r2 <= 0 && total > 0L) {
                        return total;
                    }
                    if (r2 <= 0) {
                        return r2;
                    }
                    total += (long)r2;
                }
            }
            return total;
        }
        catch (IOException | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        try {
            long state = this.state;
            if (Bits.anyAreSet(state, 0x2000000000000000L)) {
                return -1;
            }
            if (Bits.anyAreSet(state, 0x4000000000000000L)) {
                state = this.state = state & STATE_MASK | Long.MIN_VALUE;
                if (this.ajpResponseConduit.isWriteShutdown()) {
                    this.state = 0x2000000000000000L;
                    if (this.finishListener != null) {
                        this.finishListener.handleEvent(this);
                    }
                    return -1;
                }
                if (!this.ajpResponseConduit.doGetRequestBodyChunk(READ_BODY_CHUNK.duplicate(), this)) {
                    return 0;
                }
            }
            if (Bits.anyAreSet(state, Long.MIN_VALUE)) {
                return this.doRead(dst, state);
            }
            assert (0x2000000000000000L == state);
            return -1;
        }
        catch (IOException | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRead(ByteBuffer dst, long state) throws IOException {
        long chunkRemaining;
        ByteBuffer headerBuffer = this.headerBuffer;
        long headerRead = 6 - headerBuffer.remaining();
        long remaining = this.remaining;
        if (remaining == 0L) {
            this.state = 0x2000000000000000L;
            if (this.finishListener != null) {
                this.finishListener.handleEvent(this);
            }
            return -1;
        }
        if (headerRead != 6L) {
            int read = ((StreamSourceConduit)this.next).read(headerBuffer);
            if (read == -1) {
                this.state = 0x2000000000000000L;
                if (this.finishListener != null) {
                    this.finishListener.handleEvent(this);
                }
                throw new ClosedChannelException();
            }
            if (headerBuffer.hasRemaining()) {
                if (headerBuffer.remaining() <= 2) {
                    byte b1 = headerBuffer.get(0);
                    byte b2 = headerBuffer.get(1);
                    if (b1 != 18 || b2 != 52) {
                        throw UndertowMessages.MESSAGES.wrongMagicNumber((b1 & 0xFF) << 8 | b2 & 0xFF);
                    }
                    b1 = headerBuffer.get(2);
                    int totalSize = (b1 & 0xFF) << 8 | (b2 = headerBuffer.get(3)) & 0xFF;
                    if (totalSize == 0) {
                        if (headerBuffer.remaining() < 2) {
                            byte[] data = new byte[1];
                            ByteBuffer bb = ByteBuffer.wrap(data);
                            bb.put(headerBuffer.get(4));
                            bb.flip();
                            Connectors.ungetRequestBytes(this.exchange, new ImmediatePooledByteBuffer(bb));
                        }
                        this.remaining = 0L;
                        this.state = 0x2000000000000000L;
                        if (this.finishListener != null) {
                            this.finishListener.handleEvent(this);
                        }
                        return -1;
                    }
                }
                return 0;
            }
            headerBuffer.flip();
            byte b1 = headerBuffer.get();
            byte b2 = headerBuffer.get();
            if (b1 != 18 || b2 != 52) {
                throw UndertowMessages.MESSAGES.wrongMagicNumber((b1 & 0xFF) << 8 | b2 & 0xFF);
            }
            b1 = headerBuffer.get();
            int totalSize = (b1 & 0xFF) << 8 | (b2 = headerBuffer.get()) & 0xFF;
            if (totalSize == 0) {
                byte[] data = new byte[2];
                ByteBuffer bb = ByteBuffer.wrap(data);
                bb.put(headerBuffer);
                bb.flip();
                Connectors.ungetRequestBytes(this.exchange, new ImmediatePooledByteBuffer(bb));
                this.remaining = 0L;
                this.state = 0x2000000000000000L;
                if (this.finishListener != null) {
                    this.finishListener.handleEvent(this);
                }
                return -1;
            }
            b1 = headerBuffer.get();
            chunkRemaining = (b1 & 0xFF) << 8 | (b2 = headerBuffer.get()) & 0xFF;
            if (chunkRemaining == 0L) {
                this.remaining = 0L;
                this.state = 0x2000000000000000L;
                if (this.finishListener != null) {
                    this.finishListener.handleEvent(this);
                }
                return -1;
            }
        } else {
            chunkRemaining = this.state & STATE_MASK;
        }
        int limit = dst.limit();
        try {
            if ((long)dst.remaining() > chunkRemaining) {
                dst.limit((int)((long)dst.position() + chunkRemaining));
            }
            int read = ((StreamSourceConduit)this.next).read(dst);
            chunkRemaining -= (long)read;
            if (remaining != -1L) {
                remaining -= (long)read;
            }
            this.totalRead += (long)read;
            if (remaining != 0L) {
                if (chunkRemaining == 0L) {
                    headerBuffer.clear();
                    this.state = 0x4000000000000000L;
                } else {
                    this.state = state & (STATE_MASK ^ 0xFFFFFFFFFFFFFFFFL) | chunkRemaining;
                }
            }
            int n2 = read;
            return n2;
        }
        finally {
            this.remaining = remaining;
            dst.limit(limit);
            long maxEntitySize = this.exchange.getMaxEntitySize();
            if (maxEntitySize > 0L && this.totalRead > maxEntitySize) {
                this.terminateReads();
                this.exchange.setPersistent(false);
                throw UndertowMessages.MESSAGES.requestEntityWasTooLarge(maxEntitySize);
            }
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        try {
            if (Bits.anyAreSet(this.state, Long.MIN_VALUE)) {
                ((StreamSourceConduit)this.next).awaitReadable();
            }
        }
        catch (IOException | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        try {
            if (Bits.anyAreSet(this.state, Long.MIN_VALUE)) {
                ((StreamSourceConduit)this.next).awaitReadable(time, timeUnit);
            }
        }
        catch (IOException | RuntimeException e2) {
            IoUtils.safeClose((Closeable)this.exchange.getConnection());
            throw e2;
        }
    }

    void setReadBodyChunkError(IOException e2) {
        IoUtils.safeClose((Closeable)this.exchange.getConnection());
        if (this.isReadResumed()) {
            this.wakeupReads();
        }
    }

    static {
        ByteBuffer readBody = ByteBuffer.allocateDirect(7);
        readBody.put((byte)65);
        readBody.put((byte)66);
        readBody.put((byte)0);
        readBody.put((byte)3);
        readBody.put((byte)6);
        readBody.put((byte)31);
        readBody.put((byte)-6);
        readBody.flip();
        READ_BODY_CHUNK = readBody;
        STATE_MASK = Bits.longBitMask(0, 60);
    }
}

