/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ALPNBannedCiphers {
    private static final Map<String, Key> CIPHERS;
    private static final Map<Key, String> REVERSE_CIPHERS;
    private static final Set<String> ALPN_BANNED_CIPHERS;

    ALPNBannedCiphers() {
    }

    static boolean isAllowed(byte b1, byte b2) {
        String cipher = REVERSE_CIPHERS.get(new Key(b1, b2));
        if (cipher == null) {
            return true;
        }
        return !ALPN_BANNED_CIPHERS.contains(cipher);
    }

    static boolean isAllowed(String cipher) {
        return !ALPN_BANNED_CIPHERS.contains(cipher);
    }

    static {
        HashMap<String, Key> ciphers = new HashMap<String, Key>();
        ciphers.put("TLS_NULL_WITH_NULL_NULL", new Key(0, 0));
        ciphers.put("TLS_RSA_WITH_NULL_MD5", new Key(0, 1));
        ciphers.put("TLS_RSA_WITH_NULL_SHA", new Key(0, 2));
        ciphers.put("TLS_RSA_EXPORT_WITH_RC4_40_MD5", new Key(0, 3));
        ciphers.put("TLS_RSA_WITH_RC4_128_MD5", new Key(0, 4));
        ciphers.put("TLS_RSA_WITH_RC4_128_SHA", new Key(0, 5));
        ciphers.put("TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5", new Key(0, 6));
        ciphers.put("TLS_RSA_WITH_IDEA_CBC_SHA", new Key(0, 7));
        ciphers.put("TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", new Key(0, 8));
        ciphers.put("TLS_RSA_WITH_DES_CBC_SHA", new Key(0, 9));
        ciphers.put("TLS_RSA_WITH_3DES_EDE_CBC_SHA", new Key(0, 10));
        ciphers.put("TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", new Key(0, 11));
        ciphers.put("TLS_DH_DSS_WITH_DES_CBC_SHA", new Key(0, 12));
        ciphers.put("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA", new Key(0, 13));
        ciphers.put("TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", new Key(0, 14));
        ciphers.put("TLS_DH_RSA_WITH_DES_CBC_SHA", new Key(0, 15));
        ciphers.put("TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA", new Key(0, 16));
        ciphers.put("TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", new Key(0, 17));
        ciphers.put("TLS_DHE_DSS_WITH_DES_CBC_SHA", new Key(0, 18));
        ciphers.put("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", new Key(0, 19));
        ciphers.put("TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", new Key(0, 20));
        ciphers.put("TLS_DHE_RSA_WITH_DES_CBC_SHA", new Key(0, 21));
        ciphers.put("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", new Key(0, 22));
        ciphers.put("TLS_DH_anon_EXPORT_WITH_RC4_40_MD5", new Key(0, 23));
        ciphers.put("TLS_DH_anon_WITH_RC4_128_MD5", new Key(0, 24));
        ciphers.put("TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA", new Key(0, 25));
        ciphers.put("TLS_DH_anon_WITH_DES_CBC_SHA", new Key(0, 26));
        ciphers.put("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA", new Key(0, 27));
        ciphers.put("TLS_KRB5_WITH_DES_CBC_SHA", new Key(0, 30));
        ciphers.put("TLS_KRB5_WITH_3DES_EDE_CBC_SHA", new Key(0, 31));
        ciphers.put("TLS_KRB5_WITH_RC4_128_SHA", new Key(0, 32));
        ciphers.put("TLS_KRB5_WITH_IDEA_CBC_SHA", new Key(0, 33));
        ciphers.put("TLS_KRB5_WITH_DES_CBC_MD5", new Key(0, 34));
        ciphers.put("TLS_KRB5_WITH_3DES_EDE_CBC_MD5", new Key(0, 35));
        ciphers.put("TLS_KRB5_WITH_RC4_128_MD5", new Key(0, 36));
        ciphers.put("TLS_KRB5_WITH_IDEA_CBC_MD5", new Key(0, 37));
        ciphers.put("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", new Key(0, 38));
        ciphers.put("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA", new Key(0, 39));
        ciphers.put("TLS_KRB5_EXPORT_WITH_RC4_40_SHA", new Key(0, 40));
        ciphers.put("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", new Key(0, 41));
        ciphers.put("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5", new Key(0, 42));
        ciphers.put("TLS_KRB5_EXPORT_WITH_RC4_40_MD5", new Key(0, 43));
        ciphers.put("TLS_PSK_WITH_NULL_SHA", new Key(0, 44));
        ciphers.put("TLS_DHE_PSK_WITH_NULL_SHA", new Key(0, 45));
        ciphers.put("TLS_RSA_PSK_WITH_NULL_SHA", new Key(0, 46));
        ciphers.put("TLS_RSA_WITH_AES_128_CBC_SHA", new Key(0, 47));
        ciphers.put("TLS_DH_DSS_WITH_AES_128_CBC_SHA", new Key(0, 48));
        ciphers.put("TLS_DH_RSA_WITH_AES_128_CBC_SHA", new Key(0, 49));
        ciphers.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", new Key(0, 50));
        ciphers.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", new Key(0, 51));
        ciphers.put("TLS_DH_anon_WITH_AES_128_CBC_SHA", new Key(0, 52));
        ciphers.put("TLS_RSA_WITH_AES_256_CBC_SHA", new Key(0, 53));
        ciphers.put("TLS_DH_DSS_WITH_AES_256_CBC_SHA", new Key(0, 54));
        ciphers.put("TLS_DH_RSA_WITH_AES_256_CBC_SHA", new Key(0, 55));
        ciphers.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", new Key(0, 56));
        ciphers.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", new Key(0, 57));
        ciphers.put("TLS_DH_anon_WITH_AES_256_CBC_SHA", new Key(0, 58));
        ciphers.put("TLS_RSA_WITH_NULL_SHA256", new Key(0, 59));
        ciphers.put("TLS_RSA_WITH_AES_128_CBC_SHA256", new Key(0, 60));
        ciphers.put("TLS_RSA_WITH_AES_256_CBC_SHA256", new Key(0, 61));
        ciphers.put("TLS_DH_DSS_WITH_AES_128_CBC_SHA256", new Key(0, 62));
        ciphers.put("TLS_DH_RSA_WITH_AES_128_CBC_SHA256", new Key(0, 63));
        ciphers.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", new Key(0, 64));
        ciphers.put("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", new Key(0, 65));
        ciphers.put("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA", new Key(0, 66));
        ciphers.put("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA", new Key(0, 67));
        ciphers.put("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", new Key(0, 68));
        ciphers.put("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", new Key(0, 69));
        ciphers.put("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA", new Key(0, 70));
        ciphers.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", new Key(0, 103));
        ciphers.put("TLS_DH_DSS_WITH_AES_256_CBC_SHA256", new Key(0, 104));
        ciphers.put("TLS_DH_RSA_WITH_AES_256_CBC_SHA256", new Key(0, 105));
        ciphers.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", new Key(0, 106));
        ciphers.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", new Key(0, 107));
        ciphers.put("TLS_DH_anon_WITH_AES_128_CBC_SHA256", new Key(0, 108));
        ciphers.put("TLS_DH_anon_WITH_AES_256_CBC_SHA256", new Key(0, 109));
        ciphers.put("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", new Key(0, 132));
        ciphers.put("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA", new Key(0, 133));
        ciphers.put("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA", new Key(0, 134));
        ciphers.put("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", new Key(0, 135));
        ciphers.put("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", new Key(0, 136));
        ciphers.put("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA", new Key(0, 137));
        ciphers.put("TLS_PSK_WITH_RC4_128_SHA", new Key(0, 138));
        ciphers.put("TLS_PSK_WITH_3DES_EDE_CBC_SHA", new Key(0, 139));
        ciphers.put("TLS_PSK_WITH_AES_128_CBC_SHA", new Key(0, 140));
        ciphers.put("TLS_PSK_WITH_AES_256_CBC_SHA", new Key(0, 141));
        ciphers.put("TLS_DHE_PSK_WITH_RC4_128_SHA", new Key(0, 142));
        ciphers.put("TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA", new Key(0, 143));
        ciphers.put("TLS_DHE_PSK_WITH_AES_128_CBC_SHA", new Key(0, 144));
        ciphers.put("TLS_DHE_PSK_WITH_AES_256_CBC_SHA", new Key(0, 145));
        ciphers.put("TLS_RSA_PSK_WITH_RC4_128_SHA", new Key(0, 146));
        ciphers.put("TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA", new Key(0, 147));
        ciphers.put("TLS_RSA_PSK_WITH_AES_128_CBC_SHA", new Key(0, 148));
        ciphers.put("TLS_RSA_PSK_WITH_AES_256_CBC_SHA", new Key(0, 149));
        ciphers.put("TLS_RSA_WITH_SEED_CBC_SHA", new Key(0, 150));
        ciphers.put("TLS_DH_DSS_WITH_SEED_CBC_SHA", new Key(0, 151));
        ciphers.put("TLS_DH_RSA_WITH_SEED_CBC_SHA", new Key(0, 152));
        ciphers.put("TLS_DHE_DSS_WITH_SEED_CBC_SHA", new Key(0, 153));
        ciphers.put("TLS_DHE_RSA_WITH_SEED_CBC_SHA", new Key(0, 154));
        ciphers.put("TLS_DH_anon_WITH_SEED_CBC_SHA", new Key(0, 155));
        ciphers.put("TLS_RSA_WITH_AES_128_GCM_SHA256", new Key(0, 156));
        ciphers.put("TLS_RSA_WITH_AES_256_GCM_SHA384", new Key(0, 157));
        ciphers.put("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", new Key(0, 158));
        ciphers.put("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", new Key(0, 159));
        ciphers.put("TLS_DH_RSA_WITH_AES_128_GCM_SHA256", new Key(0, 160));
        ciphers.put("TLS_DH_RSA_WITH_AES_256_GCM_SHA384", new Key(0, 161));
        ciphers.put("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", new Key(0, 162));
        ciphers.put("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", new Key(0, 163));
        ciphers.put("TLS_DH_DSS_WITH_AES_128_GCM_SHA256", new Key(0, 164));
        ciphers.put("TLS_DH_DSS_WITH_AES_256_GCM_SHA384", new Key(0, 165));
        ciphers.put("TLS_DH_anon_WITH_AES_128_GCM_SHA256", new Key(0, 166));
        ciphers.put("TLS_DH_anon_WITH_AES_256_GCM_SHA384", new Key(0, 167));
        ciphers.put("TLS_PSK_WITH_AES_128_GCM_SHA256", new Key(0, 168));
        ciphers.put("TLS_PSK_WITH_AES_256_GCM_SHA384", new Key(0, 169));
        ciphers.put("TLS_DHE_PSK_WITH_AES_128_GCM_SHA256", new Key(0, 170));
        ciphers.put("TLS_DHE_PSK_WITH_AES_256_GCM_SHA384", new Key(0, 171));
        ciphers.put("TLS_RSA_PSK_WITH_AES_128_GCM_SHA256", new Key(0, 172));
        ciphers.put("TLS_RSA_PSK_WITH_AES_256_GCM_SHA384", new Key(0, 173));
        ciphers.put("TLS_PSK_WITH_AES_128_CBC_SHA256", new Key(0, 174));
        ciphers.put("TLS_PSK_WITH_AES_256_CBC_SHA384", new Key(0, 175));
        ciphers.put("TLS_PSK_WITH_NULL_SHA256", new Key(0, 176));
        ciphers.put("TLS_PSK_WITH_NULL_SHA384", new Key(0, 177));
        ciphers.put("TLS_DHE_PSK_WITH_AES_128_CBC_SHA256", new Key(0, 178));
        ciphers.put("TLS_DHE_PSK_WITH_AES_256_CBC_SHA384", new Key(0, 179));
        ciphers.put("TLS_DHE_PSK_WITH_NULL_SHA256", new Key(0, 180));
        ciphers.put("TLS_DHE_PSK_WITH_NULL_SHA384", new Key(0, 181));
        ciphers.put("TLS_RSA_PSK_WITH_AES_128_CBC_SHA256", new Key(0, 182));
        ciphers.put("TLS_RSA_PSK_WITH_AES_256_CBC_SHA384", new Key(0, 183));
        ciphers.put("TLS_RSA_PSK_WITH_NULL_SHA256", new Key(0, 184));
        ciphers.put("TLS_RSA_PSK_WITH_NULL_SHA384", new Key(0, 185));
        ciphers.put("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256", new Key(0, 186));
        ciphers.put("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256", new Key(0, 187));
        ciphers.put("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256", new Key(0, 188));
        ciphers.put("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256", new Key(0, 189));
        ciphers.put("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", new Key(0, 190));
        ciphers.put("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256", new Key(0, 191));
        ciphers.put("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256", new Key(0, 192));
        ciphers.put("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256", new Key(0, 193));
        ciphers.put("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256", new Key(0, 194));
        ciphers.put("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256", new Key(0, 195));
        ciphers.put("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256", new Key(0, 196));
        ciphers.put("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256", new Key(0, 197));
        ciphers.put("TLS_EMPTY_RENEGOTIATION_INFO_SCSV", new Key(0, 255));
        ciphers.put("TLS_FALLBACK_SCSV", new Key(86, 0));
        ciphers.put("TLS_ECDH_ECDSA_WITH_NULL_SHA", new Key(192, 1));
        ciphers.put("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", new Key(192, 2));
        ciphers.put("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", new Key(192, 3));
        ciphers.put("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", new Key(192, 4));
        ciphers.put("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", new Key(192, 5));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_NULL_SHA", new Key(192, 6));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", new Key(192, 7));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", new Key(192, 8));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", new Key(192, 9));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", new Key(192, 10));
        ciphers.put("TLS_ECDH_RSA_WITH_NULL_SHA", new Key(192, 11));
        ciphers.put("TLS_ECDH_RSA_WITH_RC4_128_SHA", new Key(192, 12));
        ciphers.put("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", new Key(192, 13));
        ciphers.put("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", new Key(192, 14));
        ciphers.put("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", new Key(192, 15));
        ciphers.put("TLS_ECDHE_RSA_WITH_NULL_SHA", new Key(192, 16));
        ciphers.put("TLS_ECDHE_RSA_WITH_RC4_128_SHA", new Key(192, 17));
        ciphers.put("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", new Key(192, 18));
        ciphers.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", new Key(192, 19));
        ciphers.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", new Key(192, 20));
        ciphers.put("TLS_ECDH_anon_WITH_NULL_SHA", new Key(192, 21));
        ciphers.put("TLS_ECDH_anon_WITH_RC4_128_SHA", new Key(192, 22));
        ciphers.put("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", new Key(192, 23));
        ciphers.put("TLS_ECDH_anon_WITH_AES_128_CBC_SHA", new Key(192, 24));
        ciphers.put("TLS_ECDH_anon_WITH_AES_256_CBC_SHA", new Key(192, 25));
        ciphers.put("TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA", new Key(192, 26));
        ciphers.put("TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA", new Key(192, 27));
        ciphers.put("TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA", new Key(192, 28));
        ciphers.put("TLS_SRP_SHA_WITH_AES_128_CBC_SHA", new Key(192, 29));
        ciphers.put("TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA", new Key(192, 30));
        ciphers.put("TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA", new Key(192, 31));
        ciphers.put("TLS_SRP_SHA_WITH_AES_256_CBC_SHA", new Key(192, 32));
        ciphers.put("TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA", new Key(192, 33));
        ciphers.put("TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA", new Key(192, 34));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", new Key(192, 35));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", new Key(192, 36));
        ciphers.put("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", new Key(192, 37));
        ciphers.put("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", new Key(192, 38));
        ciphers.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", new Key(192, 39));
        ciphers.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", new Key(192, 40));
        ciphers.put("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", new Key(192, 41));
        ciphers.put("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", new Key(192, 42));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", new Key(192, 43));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", new Key(192, 44));
        ciphers.put("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", new Key(192, 45));
        ciphers.put("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", new Key(192, 46));
        ciphers.put("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", new Key(192, 47));
        ciphers.put("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", new Key(192, 48));
        ciphers.put("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", new Key(192, 49));
        ciphers.put("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", new Key(192, 50));
        ciphers.put("TLS_ECDHE_PSK_WITH_RC4_128_SHA", new Key(192, 51));
        ciphers.put("TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA", new Key(192, 52));
        ciphers.put("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", new Key(192, 53));
        ciphers.put("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", new Key(192, 54));
        ciphers.put("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256", new Key(192, 55));
        ciphers.put("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384", new Key(192, 56));
        ciphers.put("TLS_ECDHE_PSK_WITH_NULL_SHA", new Key(192, 57));
        ciphers.put("TLS_ECDHE_PSK_WITH_NULL_SHA256", new Key(192, 58));
        ciphers.put("TLS_ECDHE_PSK_WITH_NULL_SHA384", new Key(192, 59));
        ciphers.put("TLS_RSA_WITH_ARIA_128_CBC_SHA256", new Key(192, 60));
        ciphers.put("TLS_RSA_WITH_ARIA_256_CBC_SHA384", new Key(192, 61));
        ciphers.put("TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256", new Key(192, 62));
        ciphers.put("TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384", new Key(192, 63));
        ciphers.put("TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256", new Key(192, 64));
        ciphers.put("TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384", new Key(192, 65));
        ciphers.put("TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256", new Key(192, 66));
        ciphers.put("TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384", new Key(192, 67));
        ciphers.put("TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256", new Key(192, 68));
        ciphers.put("TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384", new Key(192, 69));
        ciphers.put("TLS_DH_anon_WITH_ARIA_128_CBC_SHA256", new Key(192, 70));
        ciphers.put("TLS_DH_anon_WITH_ARIA_256_CBC_SHA384", new Key(192, 71));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256", new Key(192, 72));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384", new Key(192, 73));
        ciphers.put("TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256", new Key(192, 74));
        ciphers.put("TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384", new Key(192, 75));
        ciphers.put("TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256", new Key(192, 76));
        ciphers.put("TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384", new Key(192, 77));
        ciphers.put("TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256", new Key(192, 78));
        ciphers.put("TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384", new Key(192, 79));
        ciphers.put("TLS_RSA_WITH_ARIA_128_GCM_SHA256", new Key(192, 80));
        ciphers.put("TLS_RSA_WITH_ARIA_256_GCM_SHA384", new Key(192, 81));
        ciphers.put("TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256", new Key(192, 82));
        ciphers.put("TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384", new Key(192, 83));
        ciphers.put("TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256", new Key(192, 84));
        ciphers.put("TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384", new Key(192, 85));
        ciphers.put("TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256", new Key(192, 86));
        ciphers.put("TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384", new Key(192, 87));
        ciphers.put("TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256", new Key(192, 88));
        ciphers.put("TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384", new Key(192, 89));
        ciphers.put("TLS_DH_anon_WITH_ARIA_128_GCM_SHA256", new Key(192, 90));
        ciphers.put("TLS_DH_anon_WITH_ARIA_256_GCM_SHA384", new Key(192, 91));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256", new Key(192, 92));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384", new Key(192, 93));
        ciphers.put("TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256", new Key(192, 94));
        ciphers.put("TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384", new Key(192, 95));
        ciphers.put("TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256", new Key(192, 96));
        ciphers.put("TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384", new Key(192, 97));
        ciphers.put("TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256", new Key(192, 98));
        ciphers.put("TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384", new Key(192, 99));
        ciphers.put("TLS_PSK_WITH_ARIA_128_CBC_SHA256", new Key(192, 100));
        ciphers.put("TLS_PSK_WITH_ARIA_256_CBC_SHA384", new Key(192, 101));
        ciphers.put("TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256", new Key(192, 102));
        ciphers.put("TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384", new Key(192, 103));
        ciphers.put("TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256", new Key(192, 104));
        ciphers.put("TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384", new Key(192, 105));
        ciphers.put("TLS_PSK_WITH_ARIA_128_GCM_SHA256", new Key(192, 106));
        ciphers.put("TLS_PSK_WITH_ARIA_256_GCM_SHA384", new Key(192, 107));
        ciphers.put("TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256", new Key(192, 108));
        ciphers.put("TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384", new Key(192, 109));
        ciphers.put("TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256", new Key(192, 110));
        ciphers.put("TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384", new Key(192, 111));
        ciphers.put("TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256", new Key(192, 112));
        ciphers.put("TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384", new Key(192, 113));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", new Key(192, 114));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", new Key(192, 115));
        ciphers.put("TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", new Key(192, 116));
        ciphers.put("TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", new Key(192, 117));
        ciphers.put("TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", new Key(192, 118));
        ciphers.put("TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384", new Key(192, 119));
        ciphers.put("TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256", new Key(192, 120));
        ciphers.put("TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384", new Key(192, 121));
        ciphers.put("TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 122));
        ciphers.put("TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 123));
        ciphers.put("TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 124));
        ciphers.put("TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 125));
        ciphers.put("TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 126));
        ciphers.put("TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 127));
        ciphers.put("TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 128));
        ciphers.put("TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 129));
        ciphers.put("TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 130));
        ciphers.put("TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 131));
        ciphers.put("TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 132));
        ciphers.put("TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 133));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 134));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 135));
        ciphers.put("TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 136));
        ciphers.put("TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 137));
        ciphers.put("TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 138));
        ciphers.put("TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 139));
        ciphers.put("TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 140));
        ciphers.put("TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 141));
        ciphers.put("TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 142));
        ciphers.put("TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 143));
        ciphers.put("TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 144));
        ciphers.put("TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 145));
        ciphers.put("TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256", new Key(192, 146));
        ciphers.put("TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384", new Key(192, 147));
        ciphers.put("TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256", new Key(192, 148));
        ciphers.put("TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384", new Key(192, 149));
        ciphers.put("TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", new Key(192, 150));
        ciphers.put("TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", new Key(192, 151));
        ciphers.put("TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256", new Key(192, 152));
        ciphers.put("TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384", new Key(192, 153));
        ciphers.put("TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", new Key(192, 154));
        ciphers.put("TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", new Key(192, 155));
        ciphers.put("TLS_RSA_WITH_AES_128_CCM", new Key(192, 156));
        ciphers.put("TLS_RSA_WITH_AES_256_CCM", new Key(192, 157));
        ciphers.put("TLS_DHE_RSA_WITH_AES_128_CCM", new Key(192, 158));
        ciphers.put("TLS_DHE_RSA_WITH_AES_256_CCM", new Key(192, 159));
        ciphers.put("TLS_RSA_WITH_AES_128_CCM_8", new Key(192, 160));
        ciphers.put("TLS_RSA_WITH_AES_256_CCM_8", new Key(192, 161));
        ciphers.put("TLS_DHE_RSA_WITH_AES_128_CCM_8", new Key(192, 162));
        ciphers.put("TLS_DHE_RSA_WITH_AES_256_CCM_8", new Key(192, 163));
        ciphers.put("TLS_PSK_WITH_AES_128_CCM", new Key(192, 164));
        ciphers.put("TLS_PSK_WITH_AES_256_CCM", new Key(192, 165));
        ciphers.put("TLS_DHE_PSK_WITH_AES_128_CCM", new Key(192, 166));
        ciphers.put("TLS_DHE_PSK_WITH_AES_256_CCM", new Key(192, 167));
        ciphers.put("TLS_PSK_WITH_AES_128_CCM_8", new Key(192, 168));
        ciphers.put("TLS_PSK_WITH_AES_256_CCM_8", new Key(192, 169));
        ciphers.put("TLS_PSK_DHE_WITH_AES_128_CCM_8", new Key(192, 170));
        ciphers.put("TLS_PSK_DHE_WITH_AES_256_CCM_8", new Key(192, 171));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_128_CCM", new Key(192, 172));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_256_CCM", new Key(192, 173));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8", new Key(192, 174));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8", new Key(192, 175));
        ciphers.put("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", new Key(204, 168));
        ciphers.put("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", new Key(204, 169));
        ciphers.put("TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", new Key(204, 170));
        ciphers.put("TLS_PSK_WITH_CHACHA20_POLY1305_SHA256", new Key(204, 171));
        ciphers.put("TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256", new Key(204, 172));
        ciphers.put("TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256", new Key(204, 173));
        ciphers.put("TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256", new Key(204, 174));
        CIPHERS = Collections.unmodifiableMap(ciphers);
        HashMap reverse = new HashMap();
        for (Map.Entry e2 : ciphers.entrySet()) {
            reverse.put(e2.getValue(), e2.getKey());
        }
        REVERSE_CIPHERS = Collections.unmodifiableMap(reverse);
        HashSet<String> banned = new HashSet<String>();
        banned.add("TLS_NULL_WITH_NULL_NULL");
        banned.add("TLS_RSA_WITH_NULL_MD5");
        banned.add("TLS_RSA_WITH_NULL_SHA");
        banned.add("TLS_RSA_EXPORT_WITH_RC4_40_MD5");
        banned.add("TLS_RSA_WITH_RC4_128_MD5");
        banned.add("TLS_RSA_WITH_RC4_128_SHA");
        banned.add("TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5");
        banned.add("TLS_RSA_WITH_IDEA_CBC_SHA");
        banned.add("TLS_RSA_EXPORT_WITH_DES40_CBC_SHA");
        banned.add("TLS_RSA_WITH_DES_CBC_SHA");
        banned.add("TLS_RSA_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA");
        banned.add("TLS_DH_DSS_WITH_DES_CBC_SHA");
        banned.add("TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA");
        banned.add("TLS_DH_RSA_WITH_DES_CBC_SHA");
        banned.add("TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
        banned.add("TLS_DHE_DSS_WITH_DES_CBC_SHA");
        banned.add("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
        banned.add("TLS_DHE_RSA_WITH_DES_CBC_SHA");
        banned.add("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_DH_anon_EXPORT_WITH_RC4_40_MD5");
        banned.add("TLS_DH_anon_WITH_RC4_128_MD5");
        banned.add("TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        banned.add("TLS_DH_anon_WITH_DES_CBC_SHA");
        banned.add("TLS_DH_anon_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_KRB5_WITH_DES_CBC_SHA");
        banned.add("TLS_KRB5_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_KRB5_WITH_RC4_128_SHA");
        banned.add("TLS_KRB5_WITH_IDEA_CBC_SHA");
        banned.add("TLS_KRB5_WITH_DES_CBC_MD5");
        banned.add("TLS_KRB5_WITH_3DES_EDE_CBC_MD5");
        banned.add("TLS_KRB5_WITH_RC4_128_MD5");
        banned.add("TLS_KRB5_WITH_IDEA_CBC_MD5");
        banned.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA");
        banned.add("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA");
        banned.add("TLS_KRB5_EXPORT_WITH_RC4_40_SHA");
        banned.add("TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5");
        banned.add("TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5");
        banned.add("TLS_KRB5_EXPORT_WITH_RC4_40_MD5");
        banned.add("TLS_PSK_WITH_NULL_SHA");
        banned.add("TLS_DHE_PSK_WITH_NULL_SHA");
        banned.add("TLS_RSA_PSK_WITH_NULL_SHA");
        banned.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        banned.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA");
        banned.add("TLS_DH_RSA_WITH_AES_128_CBC_SHA");
        banned.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        banned.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
        banned.add("TLS_DH_anon_WITH_AES_128_CBC_SHA");
        banned.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        banned.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA");
        banned.add("TLS_DH_RSA_WITH_AES_256_CBC_SHA");
        banned.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
        banned.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
        banned.add("TLS_DH_anon_WITH_AES_256_CBC_SHA");
        banned.add("TLS_RSA_WITH_NULL_SHA256");
        banned.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_RSA_WITH_AES_256_CBC_SHA256");
        banned.add("TLS_DH_DSS_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_DH_RSA_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA");
        banned.add("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA");
        banned.add("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA");
        banned.add("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA");
        banned.add("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA");
        banned.add("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA");
        banned.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_DH_DSS_WITH_AES_256_CBC_SHA256");
        banned.add("TLS_DH_RSA_WITH_AES_256_CBC_SHA256");
        banned.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256");
        banned.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256");
        banned.add("TLS_DH_anon_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_DH_anon_WITH_AES_256_CBC_SHA256");
        banned.add("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA");
        banned.add("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA");
        banned.add("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA");
        banned.add("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA");
        banned.add("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA");
        banned.add("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA");
        banned.add("TLS_PSK_WITH_RC4_128_SHA");
        banned.add("TLS_PSK_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_PSK_WITH_AES_128_CBC_SHA");
        banned.add("TLS_PSK_WITH_AES_256_CBC_SHA");
        banned.add("TLS_DHE_PSK_WITH_RC4_128_SHA");
        banned.add("TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_DHE_PSK_WITH_AES_128_CBC_SHA");
        banned.add("TLS_DHE_PSK_WITH_AES_256_CBC_SHA");
        banned.add("TLS_RSA_PSK_WITH_RC4_128_SHA");
        banned.add("TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_RSA_PSK_WITH_AES_128_CBC_SHA");
        banned.add("TLS_RSA_PSK_WITH_AES_256_CBC_SHA");
        banned.add("TLS_RSA_WITH_SEED_CBC_SHA");
        banned.add("TLS_DH_DSS_WITH_SEED_CBC_SHA");
        banned.add("TLS_DH_RSA_WITH_SEED_CBC_SHA");
        banned.add("TLS_DHE_DSS_WITH_SEED_CBC_SHA");
        banned.add("TLS_DHE_RSA_WITH_SEED_CBC_SHA");
        banned.add("TLS_DH_anon_WITH_SEED_CBC_SHA");
        banned.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
        banned.add("TLS_RSA_WITH_AES_256_GCM_SHA384");
        banned.add("TLS_DH_RSA_WITH_AES_128_GCM_SHA256");
        banned.add("TLS_DH_RSA_WITH_AES_256_GCM_SHA384");
        banned.add("TLS_DH_DSS_WITH_AES_128_GCM_SHA256");
        banned.add("TLS_DH_DSS_WITH_AES_256_GCM_SHA384");
        banned.add("TLS_DH_anon_WITH_AES_128_GCM_SHA256");
        banned.add("TLS_DH_anon_WITH_AES_256_GCM_SHA384");
        banned.add("TLS_PSK_WITH_AES_128_GCM_SHA256");
        banned.add("TLS_PSK_WITH_AES_256_GCM_SHA384");
        banned.add("TLS_RSA_PSK_WITH_AES_128_GCM_SHA256");
        banned.add("TLS_RSA_PSK_WITH_AES_256_GCM_SHA384");
        banned.add("TLS_PSK_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_PSK_WITH_AES_256_CBC_SHA384");
        banned.add("TLS_PSK_WITH_NULL_SHA256");
        banned.add("TLS_PSK_WITH_NULL_SHA384");
        banned.add("TLS_DHE_PSK_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_DHE_PSK_WITH_AES_256_CBC_SHA384");
        banned.add("TLS_DHE_PSK_WITH_NULL_SHA256");
        banned.add("TLS_DHE_PSK_WITH_NULL_SHA384");
        banned.add("TLS_RSA_PSK_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_RSA_PSK_WITH_AES_256_CBC_SHA384");
        banned.add("TLS_RSA_PSK_WITH_NULL_SHA256");
        banned.add("TLS_RSA_PSK_WITH_NULL_SHA384");
        banned.add("TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256");
        banned.add("TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256");
        banned.add("TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256");
        banned.add("TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256");
        banned.add("TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256");
        banned.add("TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256");
        banned.add("TLS_EMPTY_RENEGOTIATION_INFO_SCSV");
        banned.add("TLS_ECDH_ECDSA_WITH_NULL_SHA");
        banned.add("TLS_ECDH_ECDSA_WITH_RC4_128_SHA");
        banned.add("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA");
        banned.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA");
        banned.add("TLS_ECDHE_ECDSA_WITH_NULL_SHA");
        banned.add("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA");
        banned.add("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        banned.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        banned.add("TLS_ECDH_RSA_WITH_NULL_SHA");
        banned.add("TLS_ECDH_RSA_WITH_RC4_128_SHA");
        banned.add("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA");
        banned.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA");
        banned.add("TLS_ECDHE_RSA_WITH_NULL_SHA");
        banned.add("TLS_ECDHE_RSA_WITH_RC4_128_SHA");
        banned.add("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        banned.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        banned.add("TLS_ECDH_anon_WITH_NULL_SHA");
        banned.add("TLS_ECDH_anon_WITH_RC4_128_SHA");
        banned.add("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_ECDH_anon_WITH_AES_128_CBC_SHA");
        banned.add("TLS_ECDH_anon_WITH_AES_256_CBC_SHA");
        banned.add("TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_SRP_SHA_WITH_AES_128_CBC_SHA");
        banned.add("TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA");
        banned.add("TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA");
        banned.add("TLS_SRP_SHA_WITH_AES_256_CBC_SHA");
        banned.add("TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA");
        banned.add("TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA");
        banned.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        banned.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384");
        banned.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        banned.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384");
        banned.add("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256");
        banned.add("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384");
        banned.add("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256");
        banned.add("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384");
        banned.add("TLS_ECDHE_PSK_WITH_RC4_128_SHA");
        banned.add("TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA");
        banned.add("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA");
        banned.add("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA");
        banned.add("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256");
        banned.add("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384");
        banned.add("TLS_ECDHE_PSK_WITH_NULL_SHA");
        banned.add("TLS_ECDHE_PSK_WITH_NULL_SHA256");
        banned.add("TLS_ECDHE_PSK_WITH_NULL_SHA384");
        banned.add("TLS_RSA_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_RSA_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_DH_anon_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_DH_anon_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_RSA_WITH_ARIA_128_GCM_SHA256");
        banned.add("TLS_RSA_WITH_ARIA_256_GCM_SHA384");
        banned.add("TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256");
        banned.add("TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384");
        banned.add("TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256");
        banned.add("TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384");
        banned.add("TLS_DH_anon_WITH_ARIA_128_GCM_SHA256");
        banned.add("TLS_DH_anon_WITH_ARIA_256_GCM_SHA384");
        banned.add("TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256");
        banned.add("TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384");
        banned.add("TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256");
        banned.add("TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384");
        banned.add("TLS_PSK_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_PSK_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_PSK_WITH_ARIA_128_GCM_SHA256");
        banned.add("TLS_PSK_WITH_ARIA_256_GCM_SHA384");
        banned.add("TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256");
        banned.add("TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384");
        banned.add("TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256");
        banned.add("TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384");
        banned.add("TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384");
        banned.add("TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384");
        banned.add("TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384");
        banned.add("TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384");
        banned.add("TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256");
        banned.add("TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384");
        banned.add("TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256");
        banned.add("TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384");
        banned.add("TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256");
        banned.add("TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384");
        banned.add("TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256");
        banned.add("TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384");
        banned.add("TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256");
        banned.add("TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384");
        banned.add("TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256");
        banned.add("TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384");
        banned.add("TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256");
        banned.add("TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384");
        banned.add("TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256");
        banned.add("TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384");
        banned.add("TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384");
        banned.add("TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384");
        banned.add("TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384");
        banned.add("TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256");
        banned.add("TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384");
        banned.add("TLS_RSA_WITH_AES_128_CCM");
        banned.add("TLS_RSA_WITH_AES_256_CCM");
        banned.add("TLS_RSA_WITH_AES_128_CCM_8");
        banned.add("TLS_RSA_WITH_AES_256_CCM_8");
        banned.add("TLS_PSK_WITH_AES_128_CCM");
        banned.add("TLS_PSK_WITH_AES_256_CCM");
        banned.add("TLS_PSK_WITH_AES_128_CCM_8");
        banned.add("TLS_PSK_WITH_AES_256_CCM_8");
        ALPN_BANNED_CIPHERS = Collections.unmodifiableSet(banned);
    }

    static class Key {
        private final byte b1;
        private final byte b2;

        Key(int b1, int b2) {
            this.b1 = (byte)b1;
            this.b2 = (byte)b2;
        }
    }
}

