/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.UndertowLogger;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import java.util.Deque;
import java.util.Locale;

public class PathParameterSessionConfig
implements SessionConfig {
    private final String name;

    public PathParameterSessionConfig(String name) {
        this.name = name;
    }

    public PathParameterSessionConfig() {
        this("JSESSIONID".toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        exchange.getPathParameters().remove(this.name);
        exchange.addPathParam(this.name, sessionId);
        UndertowLogger.SESSION_LOGGER.tracef("Setting path parameter session id %s on %s", (Object)sessionId, (Object)exchange);
    }

    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
        UndertowLogger.SESSION_LOGGER.tracef("Clearing path parameter session id %s on %s", (Object)sessionId, (Object)exchange);
        exchange.getPathParameters().remove(this.name);
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        Deque<String> stringDeque = exchange.getPathParameters().get(this.name);
        if (stringDeque == null) {
            return null;
        }
        UndertowLogger.SESSION_LOGGER.tracef("Found path parameter session id %s on %s", (Object)stringDeque.getFirst(), (Object)exchange);
        return stringDeque.getFirst();
    }

    @Override
    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        return this.findSessionId(exchange) != null ? SessionConfig.SessionCookieSource.URL : SessionConfig.SessionCookieSource.NONE;
    }

    @Override
    public String rewriteUrl(String url, String sessionId) {
        StringBuilder sb;
        int fragmentIndex;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        String fragment = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((fragmentIndex = path.lastIndexOf(59)) >= 0) {
            fragment = path.substring(fragmentIndex);
            path = path.substring(0, fragmentIndex);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            if (fragmentIndex > 0) {
                if (fragment.contains(this.name)) {
                    sb.append(';');
                    String key = null;
                    StringBuilder paramBuilder = new StringBuilder();
                    for (int i2 = 1; i2 < fragment.length(); ++i2) {
                        char c2 = fragment.charAt(i2);
                        if (key == null) {
                            if (c2 == '&' || c2 == '=') {
                                key = paramBuilder.toString();
                                paramBuilder.setLength(0);
                                if (c2 != '&') continue;
                                if (!key.equals(this.name)) {
                                    sb.append(key);
                                    sb.append('&');
                                }
                                key = null;
                                continue;
                            }
                            paramBuilder.append(c2);
                            continue;
                        }
                        if (c2 == '&') {
                            String value = paramBuilder.toString();
                            paramBuilder.setLength(0);
                            if (!key.equals(this.name)) {
                                sb.append(key);
                                sb.append('=');
                                sb.append(value);
                                sb.append('&');
                            }
                            key = null;
                            continue;
                        }
                        paramBuilder.append(c2);
                    }
                    if (paramBuilder.length() > 0) {
                        if (key == null) {
                            key = paramBuilder.toString();
                            if (!key.equals(this.name)) {
                                sb.append(key);
                                sb.append('&');
                            }
                        } else {
                            String value = paramBuilder.toString();
                            if (!key.equals(this.name)) {
                                sb.append(key);
                                sb.append('=');
                                sb.append(value);
                                sb.append('&');
                            }
                        }
                    }
                } else {
                    sb.append(fragment);
                    sb.append("&");
                }
            } else {
                sb.append(';');
            }
            sb.append(this.name);
            sb.append('=');
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        UndertowLogger.SESSION_LOGGER.tracef("Rewrote URL from %s to %s", (Object)url, (Object)sessionId);
        return sb.toString();
    }
}

