/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.UndertowMessages;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;

public final class HttpString
implements Comparable<HttpString>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] bytes;
    private final transient int hashCode;
    private final int orderInt;
    private transient String string;
    private static final Field hashCodeField;
    private static final int hashCodeBase;
    public static final HttpString EMPTY;

    public HttpString(byte[] bytes) {
        this((byte[])bytes.clone(), null);
    }

    public HttpString(byte[] bytes, int offset, int length) {
        this(Arrays.copyOfRange(bytes, offset, offset + length), null);
    }

    public HttpString(ByteBuffer buffer) {
        this(HttpString.take(buffer), null);
    }

    public HttpString(String string) {
        this(string, 0);
    }

    HttpString(String string, int orderInt) {
        this.orderInt = orderInt;
        int len = string.length();
        byte[] bytes = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u00ff') {
                throw new IllegalArgumentException("Invalid string contents " + string);
            }
            bytes[i2] = (byte)c2;
        }
        this.bytes = bytes;
        this.hashCode = HttpString.calcHashCode(bytes);
        this.string = string;
        this.checkForNewlines();
    }

    private void checkForNewlines() {
        for (byte b2 : this.bytes) {
            if (b2 != 13 && b2 != 10) continue;
            throw UndertowMessages.MESSAGES.newlineNotSupportedInHttpString(this.string);
        }
    }

    private HttpString(byte[] bytes, String string) {
        this.bytes = bytes;
        this.hashCode = HttpString.calcHashCode(bytes);
        this.string = string;
        this.orderInt = 0;
        this.checkForNewlines();
    }

    public static HttpString tryFromString(String string) {
        HttpString cached = Headers.fromCache(string);
        if (cached != null) {
            return cached;
        }
        int len = string.length();
        byte[] bytes = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u00ff') {
                return null;
            }
            bytes[i2] = (byte)c2;
        }
        return new HttpString(bytes, string);
    }

    public int length() {
        return this.bytes.length;
    }

    public byte byteAt(int idx) {
        return this.bytes[idx];
    }

    public void copyTo(int srcOffs, byte[] dst, int offs, int len) {
        System.arraycopy(this.bytes, srcOffs, dst, offs, len);
    }

    public void copyTo(byte[] dst, int offs, int len) {
        this.copyTo(0, dst, offs, len);
    }

    public void copyTo(byte[] dst, int offs) {
        this.copyTo(dst, offs, this.bytes.length);
    }

    public void appendTo(ByteBuffer buffer) {
        buffer.put(this.bytes);
    }

    public void writeTo(OutputStream output) throws IOException {
        output.write(this.bytes);
    }

    private static byte[] take(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            try {
                byte[] byArray = Arrays.copyOfRange(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                return byArray;
            }
            finally {
                buffer.position(buffer.limit());
            }
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public int compareTo(HttpString other) {
        if (this.orderInt != 0 && other.orderInt != 0) {
            return Integer.signum(this.orderInt - other.orderInt);
        }
        int len = Math.min(this.bytes.length, other.bytes.length);
        for (int i2 = 0; i2 < len; ++i2) {
            int res = Integer.signum(HttpString.higher(this.bytes[i2]) - HttpString.higher(other.bytes[i2]));
            if (res == 0) continue;
            return res;
        }
        return Integer.signum(this.bytes.length - other.bytes.length);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HttpString)) {
            return false;
        }
        HttpString otherString = (HttpString)other;
        if (this.orderInt > 0 && otherString.orderInt > 0) {
            return false;
        }
        return HttpString.bytesAreEqual(this.bytes, otherString.bytes);
    }

    public boolean equals(HttpString other) {
        return other == this || other != null && HttpString.bytesAreEqual(this.bytes, other.bytes);
    }

    private static int calcHashCode(byte[] bytes) {
        int hc = 17;
        for (byte b2 : bytes) {
            hc = (hc << 4) + hc + HttpString.higher(b2);
        }
        return hc;
    }

    private static int higher(byte b2) {
        return b2 & (b2 >= 97 && b2 <= 122 ? 223 : 255);
    }

    private static boolean bytesAreEqual(byte[] a2, byte[] b2) {
        return a2.length == b2.length && HttpString.bytesAreEquivalent(a2, b2);
    }

    private static boolean bytesAreEquivalent(byte[] a2, byte[] b2) {
        assert (a2.length == b2.length);
        int len = a2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (HttpString.higher(a2[i2]) == HttpString.higher(b2[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.string == null) {
            this.string = new String(this.bytes, 0);
        }
        return this.string;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        try {
            hashCodeField.setInt(this, HttpString.calcHashCode(this.bytes));
        }
        catch (IllegalAccessException e2) {
            throw new IllegalAccessError(e2.getMessage());
        }
    }

    static int hashCodeOf(String headerName) {
        int hc = 17;
        for (int i2 = 0; i2 < headerName.length(); ++i2) {
            hc = (hc << 4) + hc + HttpString.higher((byte)headerName.charAt(i2));
        }
        return hc;
    }

    public boolean equalToString(String headerName) {
        if (headerName.length() != this.bytes.length) {
            return false;
        }
        int len = this.bytes.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (HttpString.higher(this.bytes[i2]) == HttpString.higher((byte)headerName.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            hashCodeField = HttpString.class.getDeclaredField("hashCode");
            hashCodeField.setAccessible(true);
        }
        catch (NoSuchFieldException e2) {
            throw new NoSuchFieldError(e2.getMessage());
        }
        hashCodeBase = new Random().nextInt();
        EMPTY = new HttpString("");
    }
}

